/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import oracle.bpm.geom.Point;
import oracle.bpm.lang.Ref;
import org.jetbrains.annotations.NotNull;

public class Grid {
    @NotNull
    protected final Ref<Integer> size;
    public static final int NULL_SIZE = 1;
    public static final int MIN_SIZE = 12;
    public static final int MAX_SIZE = 48;
    public static final int SIZE_STEP = 4;

    public Grid(@NotNull Ref<Integer> size) {
        this.size = size;
    }

    @NotNull
    public static Grid createNull() {
        return new Grid((Ref<Integer>)Ref.createRef((Object)1));
    }

    @NotNull
    public Ref<Integer> getSize() {
        return this.size;
    }

    @NotNull
    public Point align(@NotNull Point unaligned) {
        int gridSize = (Integer)this.size.get();
        return new Point(this.align(unaligned.getX(), gridSize), this.align(unaligned.getY(), gridSize));
    }

    public void increaseSize() {
        if ((Integer)this.size.get() == 1) {
            this.size.set((Object)12);
        } else {
            int newSize = (Integer)this.size.get() + 4;
            this.size.set((Object)(newSize > 48 ? 48 : newSize));
        }
    }

    public void decreaseSize() {
        if ((Integer)this.size.get() == 1) {
            return;
        }
        if ((Integer)this.size.get() == 12) {
            this.size.set((Object)1);
        } else {
            int newSize = (Integer)this.size.get() - 4;
            this.size.set((Object)(newSize < 12 ? 12 : newSize));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grid that = (Grid)o;
        return this.size.equals(that.size);
    }

    public int hashCode() {
        return this.size.hashCode();
    }

    private int align(int unaligned, int gridSize) {
        int rest = unaligned % gridSize;
        return rest < gridSize / 2 && unaligned > rest ? unaligned - rest : unaligned + gridSize - rest;
    }
}

