/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class DrawableVerticalLabel<T>
extends DrawableLabel<T> {
    private static Map<String, Image> roleLabels;

    protected DrawableVerticalLabel(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        super(container, owner);
    }

    protected DrawableVerticalLabel(@NotNull Drawable container, @NotNull Drawable<T> owner, @NotNull DesignerLayer layer) {
        super(container, owner, layer);
    }

    public static <T> DrawableVerticalLabel<T> create(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        return new DrawableVerticalLabel<T>(container, owner);
    }

    @Override
    protected void drawLabel(@NotNull Rectangle bounds) {
        float scale = this.getContext().getScale();
        String key = this.getLabel() + scale + this.isShowSelection() + this.getGraphics().getForeground() + this.getSpecificLabelIdentification();
        Image image = DrawableVerticalLabel.getRoleLabels().get(key);
        if (image == null) {
            image = this.buildLabelImage(key, bounds);
        }
        if (image != null) {
            this.drawLabelImage(image);
        }
    }

    protected String getSpecificLabelIdentification() {
        return "";
    }

    @Override
    protected int calculateLabelWidth(@NotNull String label, @NotNull FontMetrics metrics) {
        return metrics.getMaxAscent() + metrics.getMaxDescent() + metrics.getLeading();
    }

    @Override
    protected int calculateLabelHeight(@NotNull String label, @NotNull FontMetrics metrics) {
        return metrics.stringWidth(label);
    }

    private static Map<String, Image> getRoleLabels() {
        if (roleLabels == null) {
            roleLabels = new HashMap<String, Image>();
        }
        return roleLabels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image buildLabelImage(@NotNull String key, @NotNull Rectangle bounds) {
        Graphics graphics = this.getContext().getGraphics();
        Font font = this.getContext().scale(this.getFont());
        FontMetrics metrics = graphics.getFontMetrics(font);
        BufferedImage image = new BufferedImage(bounds.getHeight(), bounds.getWidth(), 2);
        Image result = Image.create((int)image.getWidth(), (int)image.getHeight());
        if (result != null) {
            Graphics g2 = result.getGraphics();
            try {
                g2.setFont(font);
                g2.setForeground(this.getLabelBackgroundColor());
                g2.fill(Rectangle.valueOf((Point)Point.ORIGIN, (int)bounds.getHeight(), (int)bounds.getWidth()));
                g2.setForeground(this.getLabelTextColor());
                g2.drawString(this.getLabel(), 0, metrics.getMaxAscent(), this.getLabelBackgroundColor());
            }
            finally {
                g2.dispose();
            }
            result = result.rotate90cc();
            DrawableVerticalLabel.getRoleLabels().put(key, result);
        }
        return result;
    }

    private void drawLabelImage(@NotNull Image image) {
        DiagramContext context = this.getContext();
        Graphics graphics = context.getGraphics();
        Point location = context.scale(this.getBounds().getCenter()).translate(-image.getWidth() / 2, -image.getHeight() / 2);
        graphics.drawImage(image, location.getX(), location.getY(), null);
    }
}

