/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class DrawableUtils {
    public static Point NULL_CONTROL_POINT = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);

    public static double outbound(@NotNull Drawable drawable, @NotNull Path path, boolean fwd) {
        int low = fwd ? 0 : 100;
        int high = fwd ? 9900 : 10000;
        double result = 0.0;
        while (high > low) {
            int mid = (low + high) / 2;
            result = (double)mid * 1.0E-4;
            Point2D point = path.eval(result);
            boolean inside = drawable.contains((int)point.getX(), (int)point.getY());
            if (fwd ? inside : !inside) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return result + (fwd ? 1.0E-4 : -1.0E-4);
    }

    public static oracle.bpm.ui.Image createImageForDrawable(@NotNull Drawable drawable, @NotNull DiagramContext context) {
        Rectangle bounds = drawable.getBounds().expand(1);
        return DrawableUtils.createImageForDrawable(drawable, context, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static oracle.bpm.ui.Image createImageForDrawable(@NotNull Drawable drawable, @NotNull DiagramContext context, Rectangle bounds) {
        Rectangle imageSize = context.getRectangle();
        if (imageSize == null) {
            imageSize = bounds;
        }
        BufferedImage buffered = new BufferedImage(imageSize.getWidth(), imageSize.getHeight(), 2);
        oracle.bpm.ui.Image result = oracle.bpm.ui.Image.create((Image)buffered);
        Graphics graphics = result.getGraphics();
        graphics.setClip(Rectangle.valueOf((Point)Point.ORIGIN, (int)bounds.getWidth(), (int)bounds.getHeight()));
        graphics.translate(bounds.getOrigin().flip());
        try {
            context.setRectangle(bounds);
            context.setGraphics(graphics);
            context.setAntialiasing(AntialiasingMode.ON);
            drawable.draw();
        }
        finally {
            graphics.dispose();
        }
        return result;
    }

    public static Drawable findDrawable(@NotNull Drawable container, @NotNull Object element) {
        Drawable result = null;
        Drawable drawable = container.getDrawableFor(element);
        if (drawable != null) {
            result = drawable;
        } else {
            Drawable inner;
            Iterator i$ = container.getDrawables().iterator();
            while (i$.hasNext() && (result = DrawableUtils.findDrawable(inner = (Drawable)i$.next(), element)) == null) {
            }
        }
        return result;
    }

    public static enum TransitionAnchor {
        FROM,
        MIDDLE,
        TO;

    }
}

