/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Insets;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.lang.Str;
import oracle.bpm.ui.UiManager;
import org.jetbrains.annotations.NotNull;

public abstract class DrawableLabel<T>
extends DrawableImpl<T>
implements Renderer {
    private HorizontalAlignment horizontalAlignment;
    private Insets insets = Insets.EMPTY;
    private String label;
    private LabelLocation location;
    private Drawable<T> owner;
    private Point ownerLocation;
    private float scale;
    private VerticalAlignment verticalAlignment;
    private boolean wasSelected;
    private static final Font DEFAULT_LABEL_FONT = UiManager.font((String)"Button.font");

    protected DrawableLabel(@NotNull Drawable container, @NotNull Drawable<T> owner) {
        this(container, owner, DesignerLayer.LABEL);
    }

    protected DrawableLabel(@NotNull Drawable container, @NotNull Drawable<T> owner, @NotNull DesignerLayer layer) {
        super(container, owner.getModelObject(), layer);
        this.owner = owner;
        this.setLabelLocation(LabelLocation.BOTTOM);
        this.setHorizontalAlignment(HorizontalAlignment.CENTER);
        this.setVerticalAlignment(VerticalAlignment.TOP);
        this.attachRenderer(this);
    }

    public boolean isMultiLine() {
        return false;
    }

    @Override
    public void render() {
        if (this.shouldNotBeRendered()) {
            return;
        }
        Rectangle bounds = this.getContext().scale(this.getBounds());
        Font prevFont = this.setupGraphics();
        Graphics graphics = this.getGraphics();
        Color prevColor = graphics.getForeground();
        graphics.setForeground(this.getLabelTextColor());
        this.drawLabel(bounds);
        graphics.setForeground(prevColor);
        graphics.setFont(prevFont);
    }

    public LabelLocation getLabelLocation() {
        return this.location;
    }

    public void setLabelLocation(@NotNull LabelLocation location) {
        this.location = location;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(@NotNull HorizontalAlignment alignment) {
        this.horizontalAlignment = alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(@NotNull VerticalAlignment alignment) {
        this.verticalAlignment = alignment;
    }

    public void setInsets(@NotNull Insets insets) {
        this.insets = insets;
    }

    @Override
    public void refresh() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            DiagramContext context = this.getContext();
            Font oldFont = this.setupGraphics();
            FontMetrics metrics = graphics.getFontMetrics();
            int width = context.unscale(this.calculateLabelWidth(this.getLabel(), metrics));
            int height = context.unscale(this.calculateLabelHeight(this.getLabel(), metrics));
            this.setWidth(width);
            this.setHeight(height);
            this.setLocation(this.getCenterLocationWithAlignment(width, height));
            this.scale = context.getScale();
            this.wasSelected = this.owner.isShowSelection();
            this.label = this.getLabel();
            this.ownerLocation = this.owner.getLocation();
            graphics.setFont(oldFont);
        }
    }

    @NotNull
    public String getLabel() {
        return String.valueOf(this.getModelObject());
    }

    public Font getFont() {
        return DEFAULT_LABEL_FONT;
    }

    protected abstract void drawLabel(@NotNull Rectangle var1);

    protected abstract int calculateLabelWidth(@NotNull String var1, @NotNull FontMetrics var2);

    protected abstract int calculateLabelHeight(@NotNull String var1, @NotNull FontMetrics var2);

    @Override
    protected boolean needsUpdate() {
        DiagramContext context = this.getContext();
        boolean result = super.needsUpdate();
        result |= context.getScale() != this.scale;
        result |= this.owner.isShowSelection() != this.wasSelected;
        result |= !this.getLabel().equals(this.label);
        return result |= !this.owner.getLocation().equals((Object)this.ownerLocation);
    }

    @Override
    protected Rectangle createBounds() {
        this.refresh();
        return super.createBounds();
    }

    protected Drawable<T> getOwner() {
        return this.owner;
    }

    protected Color getLabelTextColor() {
        return Color.BLACK;
    }

    protected Color getLabelBackgroundColor() {
        return Color.TRANSPARENT;
    }

    protected boolean shouldNotBeRendered() {
        return this.isHidden() || Str.isEmpty((String)this.label);
    }

    protected Point getCenterLocationWithoutAlignment() {
        Point result = this.getLabelLocation().calculateLocationOnBounds(this.getOwnerBounds());
        Dimension delta = this.getLabelLocation().calculateDeltaForInsets(this.insets);
        return result.translate(delta);
    }

    protected Rectangle getOwnerBounds() {
        return this.owner.getBounds();
    }

    protected Graphics getGraphics() {
        return this.getContext().getGraphics();
    }

    private Point getCenterLocationWithAlignment(int width, int height) {
        Point result = this.getCenterLocationWithoutAlignment();
        switch (this.getHorizontalAlignment()) {
            case LEFT: {
                result = result.translate(width / 2, 0);
                break;
            }
            case RIGHT: {
                result = result.translate(-width / 2, 0);
            }
        }
        switch (this.getVerticalAlignment()) {
            case TOP: {
                result = result.translate(0, height / 2);
                break;
            }
            case BOTTOM: {
                result = result.translate(0, -height / 2);
            }
        }
        return result;
    }

    private Font setupGraphics() {
        Graphics graphics = this.getGraphics();
        Font oldFont = graphics.getFont();
        graphics.setFont(this.getContext().scale(this.getFont()));
        return oldFont;
    }

    public static enum VerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum LabelLocation {
        TOP_LEFT(0.0, 0.0),
        TOP(0.5, 0.0),
        TOP_RIGHT(1.0, 0.0),
        CENTER_LEFT(0.0, 0.5),
        CENTER(0.5, 0.5),
        CENTER_RIGHT(1.0, 0.5),
        BOTTOM_LEFT(0.0, 1.0),
        BOTTOM(0.5, 1.0),
        BOTTOM_RIGHT(1.0, 1.0);

        private double xFactor;
        private double yFactor;

        private LabelLocation(double xFactor, double yFactor) {
            this.xFactor = xFactor;
            this.yFactor = yFactor;
        }

        protected Point calculateLocationOnBounds(@NotNull Rectangle bounds) {
            return bounds.getOrigin().translate((int)((double)bounds.getWidth() * this.xFactor), (int)((double)bounds.getHeight() * this.yFactor));
        }

        protected Dimension calculateDeltaForInsets(@NotNull Insets insets) {
            int deltaX = 0;
            int deltaY = 0;
            if (this == TOP_LEFT || this == TOP || this == TOP_RIGHT) {
                deltaY -= insets.top;
            }
            if (this == BOTTOM_LEFT || this == BOTTOM || this == BOTTOM_RIGHT) {
                deltaY += insets.bottom;
            }
            if (this == TOP_LEFT || this == CENTER_LEFT || this == BOTTOM_LEFT) {
                deltaX -= insets.left;
            }
            if (this == TOP_RIGHT || this == CENTER_RIGHT || this == BOTTOM_RIGHT) {
                deltaX += insets.right;
            }
            return Dimension.valueOf((int)deltaX, (int)deltaY);
        }
    }
}

