/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.diagram.draw;

import java.awt.Shape;
import java.awt.geom.Point2D;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableConnection;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.LineStyle;
import oracle.bpm.draw.Stroke;
import oracle.bpm.geom.Line;
import oracle.bpm.geom.Path;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrawableConnectionImpl<T>
extends DrawableImpl<T>
implements DrawableConnection<T> {
    @NotNull
    protected final AnchorLocation control;
    @NotNull
    protected final AnchorLocation source;
    @NotNull
    protected final AnchorLocation target;
    private boolean bidirectional = false;
    private int hashControl;
    private int hashSource;
    private int hashTarget;
    private DrawableLabel<T> label;
    private Path path;
    private LineStyle style;
    private static final int ARROW_LENGTH = 10;
    private static final int ARROW_WIDTH = 4;
    private static final int INTERSECTION_TOLERANCE = 12;

    protected DrawableConnectionImpl(Drawable container, @NotNull T modelObject, @NotNull DesignerLayer layer) {
        super(container, modelObject, layer);
        this.source = new AnchorLocation(container, Point.ORIGIN);
        this.target = new AnchorLocation(container, Point.ORIGIN);
        this.control = new AnchorLocation(container, DrawableUtils.NULL_CONTROL_POINT);
        this.label = this.createConnectionLabel();
    }

    @Override
    @Nullable
    public Drawable getDrawableSource() {
        return this.source.getDrawable();
    }

    @Override
    @Nullable
    public Drawable getDrawableTarget() {
        return this.target.getDrawable();
    }

    public void setDrawableSource(@NotNull Drawable source) {
        this.source.setDrawable(source);
        this.updatePath();
    }

    public void setDrawableTarget(@NotNull Drawable target) {
        this.target.setDrawable(target);
        this.updatePath();
    }

    public void setSourceLocation(@NotNull Point source) {
        this.source.setLocation(source);
        this.updatePath();
    }

    public void setTargetLocation(@NotNull Point target) {
        this.target.setLocation(target);
        this.updatePath();
    }

    public void setControlPointLocation(@NotNull Point control) {
        this.control.setLocation(control);
        this.updatePath();
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setStyle(LineStyle style) {
        this.style = style;
    }

    @Override
    @NotNull
    public Path getPath() {
        if (this.path == null) {
            throw new IllegalStateException("getPath() invoked before shape construction");
        }
        return this.path;
    }

    @Override
    @NotNull
    public Point2D getPathPoint(double t) {
        return this.getPathPoint(this.getPath(), t);
    }

    @Override
    public void draw() {
        Graphics g = this.getContext().getGraphics();
        Font previousFont = g.getFont();
        AntialiasingMode mode = g.getAntialiasing();
        g.setAntialiasing(AntialiasingMode.ON);
        this.drawPath(this.getPath());
        g.setAntialiasing(mode);
        g.setFont(previousFont);
        g.setForeground(Color.BLACK);
        super.draw();
    }

    @Override
    @NotNull
    public Point getControlPoint() {
        return this.control.location;
    }

    @Override
    public boolean contains(int x, int y) {
        this.updatePath();
        return this.getPath().intersects(Rectangle.createAround((int)x, (int)y, (int)12));
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        this.updatePath();
        return this.getPath().intersects(rectangle);
    }

    @Override
    public void add() {
        super.add();
        if (this.label != null) {
            this.label.add();
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.label != null) {
            this.label.remove();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updatePath();
    }

    @NotNull
    protected Point2D getPathPoint(@NotNull Path path, double t) {
        return path.eval(t);
    }

    protected void drawOtherDecorations(@NotNull Path path) {
    }

    @Nullable
    protected DrawableLabel<T> createConnectionLabel() {
        return null;
    }

    protected DrawableLabel getLabel() {
        return this.label;
    }

    protected Point getSourceRawLocation() {
        return this.source.getRawLocation();
    }

    protected Point getTargetRawLocation() {
        return this.target.getRawLocation();
    }

    protected void drawPath(@NotNull Path path) {
        Graphics graphics = this.getContext().getGraphics();
        Stroke s = graphics.getStroke();
        Color c = graphics.getForeground();
        if (this.isShowSelection()) {
            graphics.setStroke(Stroke.TWO_SOLID);
        }
        LineStyle original = graphics.getStroke().getStyle();
        if (this.style != null) {
            Stroke tmp = graphics.getStroke();
            tmp.setStyle(this.style);
            graphics.setStroke(tmp);
        }
        Path scaled = path.scaled(this.getContext().getScale());
        graphics.setForeground(this.getConnectionColor());
        graphics.draw((Shape)scaled);
        this.drawArrow(scaled);
        this.drawOtherDecorations(scaled);
        if (this.style != null) {
            graphics.getStroke().setStyle(original);
        }
        graphics.setStroke(s);
        graphics.setForeground(c);
    }

    protected Color getConnectionColor() {
        return Color.BLACK;
    }

    protected void drawArrow(@NotNull Path path) {
        DiagramContext context = this.getContext();
        Graphics graphics = context.getGraphics();
        Point2D p2 = this.getPathPoint(path, 1.0);
        double arrowLength = context.scale(10);
        Point2D p1 = path.findPointBackwards(p2, arrowLength, 1.0);
        graphics.drawArrow(p1.getX(), p1.getY(), p2.getX(), p2.getY(), context.scale(4));
        if (this.isBidirectional()) {
            p2 = this.getPathPoint(path, 0.0);
            p1 = path.findPoint(p2, arrowLength, 0.0);
            graphics.drawArrow(p1.getX(), p1.getY(), p2.getX(), p2.getY(), context.scale(4));
        }
    }

    protected Path createRawPath(@NotNull Point begin, @NotNull Point end) {
        return new Line(begin, end);
    }

    protected void updatePath() {
        if (!this.shouldUpdate()) {
            return;
        }
        Point begin = this.getSourceRawLocation();
        Point end = this.getTargetRawLocation();
        if (end == null) {
            if (begin == null) {
                begin = new Point(0, 0);
            }
            end = begin;
        } else if (begin == null) {
            begin = end;
        }
        Path result = this.createRawPath(begin, end);
        double t0 = 0.0;
        double t1 = 1.0;
        if (this.source.getDrawable() != null) {
            t0 = DrawableUtils.outbound(this.source.getDrawable(), result, true);
        }
        if (this.target.getDrawable() != null) {
            t1 = DrawableUtils.outbound(this.target.getDrawable(), result, false);
        }
        this.path = result = result.cropped(t0, t1);
        this.updateBounds();
        this.updateCache();
    }

    private void updateBounds() {
        Rectangle bounds = new Rectangle(this.path.getBounds2D()).expand(50);
        this.setLocation(bounds.getCenter());
        this.setWidth(bounds.getWidth());
        this.setHeight(bounds.getHeight());
    }

    private boolean shouldUpdate() {
        boolean result = this.source.cacheHash() != this.hashSource || this.hashSource == 0;
        result |= this.control.cacheHash() != this.hashControl;
        return result |= this.target.cacheHash() != this.hashTarget || this.hashTarget == 0;
    }

    private void updateCache() {
        this.hashSource = this.source.cacheHash();
        this.hashControl = this.control.cacheHash();
        this.hashTarget = this.target.cacheHash();
    }

    protected static class AnchorLocation {
        private final Drawable container;
        private Drawable drawable;
        private Point location;

        private AnchorLocation(@NotNull Drawable container, @NotNull Point location) {
            this.container = container;
            this.location = location;
        }

        public Point getRawLocation() {
            return this.location != null ? this.location : (this.drawable != null ? this.drawable.getLocation() : null);
        }

        public void setDrawable(@NotNull Drawable drawable) {
            this.drawable = drawable;
            this.location = null;
        }

        public void setLocation(@NotNull Point location) {
            this.location = location;
            this.drawable = null;
        }

        public boolean isNull() {
            return this.location != null && this.location.equals((Object)DrawableUtils.NULL_CONTROL_POINT);
        }

        private Drawable getDrawable() {
            return this.drawable;
        }

        private int cacheHash() {
            int result = this.drawable != null ? this.drawable.getBounds().hashCode() : 0;
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            return result;
        }
    }
}

