/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.views;

import oracle.bpm.fusion.studio.simulation.SimulationView;
import oracle.bpm.fusion.studio.views.DocumentationView;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;

public class StudioDockableFactory
implements DockableFactory {
    private static StudioDockableFactory instance;

    private StudioDockableFactory() {
    }

    public static StudioDockableFactory getInstance() {
        if (instance == null) {
            instance = new StudioDockableFactory();
            instance.install();
        }
        return instance;
    }

    public void install() {
        DockStation dockStation = DockStation.getDockStation();
        LogWindow log = LogManager.getIdeLogWindow();
        DockingParam dp = new DockingParam();
        if (log != null) {
            if (dockStation.getDockableStatus((Dockable)log) > 0) {
                dp.setPosition(3);
                dp.setTabbedWith((Dockable)log);
            } else {
                dp.setPosition(3);
            }
        } else {
            dp.setPosition(3);
        }
        SimulationView simulationViewInstance = SimulationView.getInstance();
        dockStation.dock((Dockable)simulationViewInstance, dp);
        dp.setPosition((Dockable)simulationViewInstance, 4);
        dockStation.dock((Dockable)DocumentationView.getInstance(), dp);
    }

    public Dockable getDockable(ViewId viewId) {
        if (viewId.getName().equals("Simulation")) {
            return SimulationView.getInstance();
        }
        if (viewId.getName().equals("Documentation")) {
            return DocumentationView.getInstance();
        }
        return null;
    }
}

