/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.thumbnail;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bpm.collections.Procedure;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.peer.swing.AwtConverter;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import org.jetbrains.annotations.NotNull;

public class ThumbnailOverViewPanel
extends JPanel
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private Component editorComponent;
    private Procedure<Boolean> remove;
    private JScrollPane scroll;
    private Dimension thumbnail;
    private PaintCanvas thumbnailComponent;
    private oracle.bpm.geom.Rectangle viewport = oracle.bpm.geom.Rectangle.ZERO;
    private JViewport viewportComponent;
    private static Font MESSAGE_FONT = null;
    private static Color LIGHT_GRAY_COLOR = Color.lightGray;

    public ThumbnailOverViewPanel(@NotNull Component component) {
        this.editorComponent = component;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.scroll = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.editorComponent);
        if (this.scroll != null) {
            this.viewportComponent = this.scroll.getViewport();
            this.viewportComponent.addChangeListener(this);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ThumbnailOverViewPanel.this.updateViewportAndThumbnail();
            }
        });
        this.updateViewportAndThumbnail();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.viewportComponent.getView() != null) {
            this.updateViewportAndThumbnail();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.mouseChanged(event.getX(), event.getY());
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.mouseChanged(event.getX(), event.getY());
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public synchronized void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.editorComponent != null) {
            if (this.viewportComponent.getView() == null) {
                return;
            }
            int tW = this.thumbnail.width;
            int tH = this.thumbnail.height;
            int tX = Math.max(0, (this.getWidth() - tW) / 2);
            boolean tY = false;
            g.setColor(new Color(148, 150, 148));
            this.thumbnailComponent.setSize(tW, tH);
            Rectangle original = g.getClipBounds();
            g.translate(tX, 0);
            g.setClip(0, 0, tW, tH);
            this.thumbnailComponent.paintCanvas(AwtConverter.fromAwt((Graphics)g));
            g.translate(-tX, 0);
            g.setClip(original);
            g.drawRect(tX, 0, tW, tH);
            if (this.viewport.getWidth() > 0 && this.viewport.getHeight() > 0) {
                oracle.bpm.geom.Rectangle top = oracle.bpm.geom.Rectangle.valueOf(tX, 0, tW, this.viewport.getY());
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)AwtConverter.toAwt((oracle.bpm.geom.Rectangle)top), (Color)LIGHT_GRAY_COLOR, (float)0.35f);
                oracle.bpm.geom.Rectangle left = oracle.bpm.geom.Rectangle.valueOf(tX, this.viewport.getY(), this.viewport.getX(), tH - this.viewport.getY());
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)AwtConverter.toAwt((oracle.bpm.geom.Rectangle)left), (Color)LIGHT_GRAY_COLOR, (float)0.35f);
                oracle.bpm.geom.Rectangle right = oracle.bpm.geom.Rectangle.valueOf(tX + this.viewport.getX() + this.viewport.getWidth(), this.viewport.getY(), tX + tW - (tX + this.viewport.getX() + this.viewport.getWidth()), tH - this.viewport.getY());
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)AwtConverter.toAwt((oracle.bpm.geom.Rectangle)right), (Color)LIGHT_GRAY_COLOR, (float)0.35f);
                oracle.bpm.geom.Rectangle bottom = oracle.bpm.geom.Rectangle.valueOf(tX + this.viewport.getX(), this.viewport.getY() + this.viewport.getHeight(), this.viewport.getWidth(), tH - (this.viewport.getY() + this.viewport.getHeight()));
                GraphUtils.paintTransparentRectangle((Graphics)g, (Rectangle)AwtConverter.toAwt((oracle.bpm.geom.Rectangle)bottom), (Color)LIGHT_GRAY_COLOR, (float)0.35f);
                GraphUtils.drawRect((Graphics)g, (int)(this.viewport.getX() + tX), (int)this.viewport.getY(), (int)this.viewport.getWidth(), (int)this.viewport.getHeight(), (int)1, (Color)LIGHT_GRAY_COLOR);
            }
        } else {
            g.setColor(LIGHT_GRAY_COLOR);
            String text = "Thumbnail Inactive";
            g.setFont(MESSAGE_FONT);
            Font f = g.getFont();
            int strWidth = GraphUtils.getStringWidth((Font)f, (String)text);
            int h = GraphUtils.getFontHeight((Font)f);
            int x = Math.max(0, (this.getWidth() - strWidth) / 2);
            int y = Math.max(0, (this.getHeight() - h) / 2);
            g.drawString(text, x, y);
        }
    }

    public void setThumbnailCanvas(PaintCanvas thumbnail) {
        this.thumbnailComponent = thumbnail;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.remove != null) {
            this.remove.execute(true);
        }
    }

    public void onRemove(Procedure<Boolean> remove) {
        this.remove = remove;
    }

    private void mouseChanged(int x, int y) {
        Point position = this.computeViewportPosition(x, y);
        int viewportRectangleX = position.x;
        int viewportRectangleY = position.y;
        this.viewport = oracle.bpm.geom.Rectangle.valueOf(viewportRectangleX, viewportRectangleY, this.viewport.getWidth(), this.viewport.getHeight());
        float pctX = (float)viewportRectangleX / (float)(this.thumbnail.width - this.viewport.getWidth());
        float pctY = (float)viewportRectangleY / (float)(this.thumbnail.height - this.viewport.getHeight());
        if (this.scroll != null) {
            Dimension graphDim = this.viewportComponent.getView().getSize();
            int graphX = Math.round(pctX * (float)(graphDim.width - this.viewportComponent.getWidth()));
            int graphY = Math.round(pctY * (float)(graphDim.height - this.viewportComponent.getHeight()));
            this.viewportComponent.setViewPosition(new Point(graphX, graphY));
        }
        this.repaint();
    }

    private void updateViewportAndThumbnail() {
        this.updateThumbnail();
        this.updateViewport();
        this.repaint();
    }

    private void updateViewport() {
        if (this.viewportComponent != null && this.editorComponent != null) {
            oracle.bpm.geom.Rectangle bounds = AwtConverter.fromAwt((Rectangle)this.viewportComponent.getViewRect());
            Component comp = this.viewportComponent.getView();
            double viewportX = (double)bounds.getX() / (double)comp.getWidth() * this.thumbnail.getWidth();
            double viewportY = (double)bounds.getY() / (double)comp.getHeight() * this.thumbnail.getHeight();
            double viewportW = (double)bounds.getWidth() / (double)comp.getWidth() * this.thumbnail.getWidth();
            double viewportH = (double)bounds.getHeight() / (double)comp.getHeight() * this.thumbnail.getHeight();
            this.viewport = oracle.bpm.geom.Rectangle.valueOf((int)Math.ceil(viewportX), (int)Math.ceil(viewportY), (int)viewportW, (int)viewportH);
        } else {
            this.viewport = oracle.bpm.geom.Rectangle.ZERO;
        }
    }

    private void updateThumbnail() {
        if (this.viewportComponent != null && this.editorComponent != null) {
            double thumbWidth;
            double thumbHeight;
            Rectangle2D.Double canvasBounds = new Rectangle2D.Double(0.0, 0.0, this.editorComponent.getBounds().width, this.editorComponent.getBounds().height);
            if (((RectangularShape)canvasBounds).getHeight() > ((RectangularShape)canvasBounds).getWidth()) {
                double ratio = ((RectangularShape)canvasBounds).getWidth() / ((RectangularShape)canvasBounds).getHeight();
                thumbWidth = ratio * (thumbHeight = (double)(this.getHeight() - 1));
                if (thumbWidth > (double)(this.getWidth() - 1)) {
                    ratio = ((RectangularShape)canvasBounds).getHeight() / ((RectangularShape)canvasBounds).getWidth();
                    thumbWidth = this.getWidth() - 1;
                    thumbHeight = ratio * thumbWidth;
                }
            } else {
                double ratio = ((RectangularShape)canvasBounds).getHeight() / ((RectangularShape)canvasBounds).getWidth();
                thumbHeight = ratio * (thumbWidth = (double)(this.getWidth() - 1));
                if (thumbHeight > (double)(this.getHeight() - 1)) {
                    ratio = ((RectangularShape)canvasBounds).getWidth() / ((RectangularShape)canvasBounds).getHeight();
                    thumbHeight = this.getHeight() - 1;
                    thumbWidth = ratio * thumbHeight;
                }
            }
            this.thumbnail = new Dimension((int)thumbWidth, (int)thumbHeight);
        }
    }

    private Point computeViewportPosition(int xMouse, int yMouse) {
        int viewportX = (xMouse -= (this.getWidth() - (int)this.thumbnail.getWidth()) / 2) - this.viewport.getWidth() / 2;
        int viewportY = yMouse - this.viewport.getHeight() / 2;
        viewportX = Math.min(viewportX, this.thumbnail.width - this.viewport.getWidth());
        viewportY = Math.min(viewportY, this.thumbnail.height - this.viewport.getHeight());
        viewportX = Math.max(viewportX, 0);
        viewportY = Math.max(viewportY, 0);
        return new Point(viewportX, viewportY);
    }

    static {
        MESSAGE_FONT = UIManager.getFont("Label.font");
    }
}

