/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.thumbnail;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import oracle.bpm.collections.Procedure;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.DrawableRegister;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

class ThumbnailEventDispatcher
extends BatchProjectListenerAdapter<FlowElement>
implements DrawableRegister {
    private final Map<ProjectObject, Drawable> drawables = new HashMap<ProjectObject, Drawable>();
    private final DrawableFactory factory;
    private Procedure<Boolean> refresh;

    public ThumbnailEventDispatcher(@NotNull DrawableFactory factory) {
        super(FlowElement.class);
        this.factory = factory;
    }

    public void processPostEvents(ProjectEventSet events) {
        LinkedHashSet<Drawable> toBeRefreshed = new LinkedHashSet<Drawable>();
        for (ProjectEvent event : events) {
            Drawable drawable;
            Drawable parent;
            ProjectObject object = event.getProjectObject();
            if (!(object instanceof FlowElement) || object instanceof Counter) continue;
            if (event.getType() == ProjectEvent.Type.POST_ADD) {
                this.addChild(this.drawables.get(object.getParentObject()), object);
            } else if (event.getType() == ProjectEvent.Type.POST_REMOVE) {
                this.removeChild(object);
            } else if (event.getType() == ProjectEvent.Type.CHANGE && (parent = this.drawables.get(object.getParentObject())) != null) {
                this.removeChild(object);
                this.addChild(parent, object);
            }
            if ((drawable = this.drawables.get(object)) == null) continue;
            toBeRefreshed.add(drawable);
        }
        for (Drawable drawable : toBeRefreshed) {
            drawable.refresh();
        }
        if (this.refresh != null) {
            this.refresh.execute(true);
        }
    }

    public void register(@NotNull Drawable drawable) {
        if (drawable instanceof DrawableFlowElement) {
            this.drawables.put((ProjectObject)drawable.getModelObject(), drawable);
        }
    }

    public void unregister(@NotNull Drawable drawable) {
        this.drawables.remove(drawable.getModelObject());
    }

    public void onRefresh(@NotNull Procedure<Boolean> procedure) {
        this.refresh = procedure;
    }

    private void addChild(@NotNull Drawable parent, @NotNull Object child) {
        Drawable drawable = this.factory.create(parent, child);
        for (Object childs : this.factory.getChildren(drawable.getModelObject())) {
            this.addChild(drawable, childs);
        }
        drawable.add();
    }

    private void removeChild(ProjectObject child) {
        Drawable drawable = this.drawables.get(child);
        if (drawable != null) {
            drawable.remove();
        }
    }
}

