/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.thumbnail;

import java.awt.Component;
import oracle.bpm.collections.Procedure;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.ProcessPreviewer;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableCreator;
import oracle.bpm.diagram.draw.DrawableFactory;
import oracle.bpm.diagram.draw.DrawableRegister;
import oracle.bpm.diagram.draw.renderer.ChildrenRenderer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.draw.DrawableEvent;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableFlowNode;
import oracle.bpm.draw.DrawableGateway;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSubprocess;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.renderer.ProcessPoolRenderer;
import oracle.bpm.draw.renderer.ProcessRenderer;
import oracle.bpm.draw.renderer.SubprocessRenderer;
import oracle.bpm.fusion.studio.thumbnail.ThumbnailEventDispatcher;
import oracle.bpm.fusion.studio.thumbnail.ThumbnailOverViewPanel;
import oracle.bpm.fusion.ui.editor.FusionEditor;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.TextAnnotationImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.diagram.thumbnail.ThumbnailViewFactory;
import oracle.ide.editor.Editor;
import org.jetbrains.annotations.NotNull;

public class ProcessThumbnailViewFactory
implements ThumbnailViewFactory {
    public Component getThumbnailComponent(Editor fusion) {
        ThumbnailOverViewPanel result;
        StudioEditor editor = ((FusionEditor)fusion).getStudioEditor();
        if (editor != null && editor.getEditorType() == EditorType.PROCESS && editor instanceof ProcessPanel) {
            final ProcessPanel panel = (ProcessPanel)editor;
            final BpmnDrawableThumbnailFactory factory = BpmnDrawableThumbnailFactory.getInstance();
            final ThumbnailEventDispatcher dispatcher = new ThumbnailEventDispatcher((DrawableFactory)factory);
            ((Process)panel.getProjectObject()).addListener((ProjectListener)dispatcher);
            result = new ThumbnailOverViewPanel(panel.getProcessDomain().getCanvas().asSwing());
            result.onRemove(new Procedure<Boolean>(){

                @Override
                public boolean execute(Boolean value) {
                    ((Process)panel.getProjectObject()).removeListener((ProjectListener)dispatcher);
                    return value;
                }
            });
            ProcessPreviewer previewer = new ProcessPreviewer((UiContainer)Ui.getRoot()){

                protected void updateContext(@NotNull Graphics graphics, @NotNull Rectangle rectangle) {
                    super.updateContext(graphics, rectangle);
                    if (rectangle.getWidth() > 0 && rectangle.getHeight() > 0) {
                        this.setScaleForBounds(rectangle.getWidth(), rectangle.getHeight());
                    }
                }

                protected DrawableFactory resolveDrawableFactory() {
                    return factory;
                }
            };
            previewer.setRegister((DrawableRegister)dispatcher);
            previewer.setProcessToRender((Process)panel.getProjectObject());
            dispatcher.onRefresh(new Procedure<Boolean>(){

                @Override
                public boolean execute(Boolean dummy) {
                    result.repaint();
                    return dummy;
                }
            });
            result.setThumbnailCanvas((PaintCanvas)previewer);
        } else {
            result = null;
        }
        return result;
    }

    private static class BpmnDrawableThumbnailFactory
    extends BpmnDrawableFactory {
        private static BpmnDrawableThumbnailFactory instance;

        private BpmnDrawableThumbnailFactory() {
        }

        public static BpmnDrawableThumbnailFactory getInstance() {
            if (instance == null) {
                instance = new BpmnDrawableThumbnailFactory();
            }
            return instance;
        }

        protected DrawableCreator processCreator() {
            return new DrawableCreator<Process>(Process.class){

                protected Drawable create(@NotNull Drawable container, @NotNull Process process) {
                    DrawableProcess drawable = new DrawableProcess(container, process);
                    drawable.attachRenderer((Renderer)ProcessRenderer.create((DrawableProcess)drawable));
                    drawable.attachRenderer(ProcessPoolRenderer.create((DrawableProcess)drawable));
                    drawable.attachRenderer((Renderer)ChildrenRenderer.createUnclipped((Drawable)drawable));
                    return drawable;
                }
            };
        }

        protected DrawableCreator subprocessCreator() {
            return new BpmnDrawableFactory.NodeContainerCreator<Subprocess>(Subprocess.class){

                protected Drawable create(final @NotNull DrawableNodeContainer container, final @NotNull Subprocess subprocess) {
                    DrawableSubprocess drawable = new DrawableSubprocess(container, subprocess){

                        public void refresh() {
                            super.refresh();
                            BpmnDrawableThumbnailFactory.this.refreshSequenceFlows(container, (FlowNode)this.getModelObject());
                            BpmnDrawableThumbnailFactory.this.refreshChildren((DrawableNodeContainer)this, subprocess);
                        }
                    };
                    drawable.attachRenderer((Renderer)SubprocessRenderer.create((DrawableFlowElement)drawable));
                    drawable.attachRenderer((Renderer)ChildrenRenderer.createClipped((Drawable)drawable));
                    return drawable;
                }

                protected boolean check(@NotNull Drawable parent, @NotNull Subprocess subprocess) {
                    return !ModelUtils.isCollapsed((Subprocess)subprocess) && super.check(parent, (Object)subprocess);
                }
            };
        }

        protected DrawableCreator eventCreator() {
            return new ThumbnailFlowNodeCreator<Event>(Event.class){

                protected DrawableFlowNode subtype(final @NotNull DrawableNodeContainer container, @NotNull Event event) {
                    return new DrawableEvent(container, event){

                        public void refresh() {
                            super.refresh();
                            BpmnDrawableThumbnailFactory.this.refreshSequenceFlows(container, (FlowNode)this.getModelObject());
                        }
                    };
                }

                protected boolean check(@NotNull Drawable parent, @NotNull FlowNode flowNode) {
                    return flowNode.isEvent() && super.check(parent, (Object)flowNode);
                }
            };
        }

        protected DrawableCreator gatewayCreator() {
            return new ThumbnailFlowNodeCreator<Gateway>(Gateway.class){

                protected DrawableFlowNode subtype(final @NotNull DrawableNodeContainer container, @NotNull Gateway gateway) {
                    return new DrawableGateway(container, gateway){

                        public void refresh() {
                            super.refresh();
                            BpmnDrawableThumbnailFactory.this.refreshSequenceFlows(container, (FlowNode)this.getModelObject());
                        }
                    };
                }

                protected boolean check(@NotNull Drawable parent, @NotNull FlowNode flowNode) {
                    return flowNode.isGateway() && super.check(parent, (Object)flowNode);
                }
            };
        }

        protected DrawableCreator activityCreator() {
            return new ThumbnailFlowNodeCreator<Activity>(Activity.class){

                protected DrawableFlowNode subtype(final @NotNull DrawableNodeContainer container, @NotNull Activity activity) {
                    return new DrawableActivity(container, activity){

                        public void refresh() {
                            super.refresh();
                            BpmnDrawableThumbnailFactory.this.refreshSequenceFlows(container, (FlowNode)this.getModelObject());
                        }
                    };
                }
            };
        }

        protected DrawableCreator textAnnotationCreator() {
            return new BpmnDrawableFactory.NodeContainerCreator<TextAnnotation>(TextAnnotation.class){

                protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull TextAnnotation text) {
                    return new DrawableFlowElementImpl<TextAnnotation>((Drawable)container, text, DesignerLayer.NOTE){

                        public void draw() {
                            DrawContext context = this.getContext();
                            Rectangle bounds = context.scale(this.getBounds());
                            Graphics graphics = context.getGraphics();
                            Color original = graphics.getForeground();
                            Image note = Image.create((Msg)DesignerMsg.NEW_NOTE);
                            graphics.drawImage(note, bounds.getX() + bounds.getWidth() / 10, bounds.getY() + bounds.getHeight() / 10, note.getWidth(), note.getHeight());
                            graphics.setForeground(Color.valueOf((Color)Color.FUEGO_LIGHT_BLUE, (int)210));
                            graphics.drawRect(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                            graphics.setForeground(original);
                            super.draw();
                        }

                        public void refresh() {
                            super.refresh();
                            this.setLocation(((TextAnnotation)this.getModelObject()).getLocation());
                            this.setWidth(Math.max(((TextAnnotation)this.getModelObject()).getWidth(), TextAnnotationImpl.MINIMUM_SIZE.getWidth()));
                            this.setHeight(Math.max(((TextAnnotation)this.getModelObject()).getHeight(), TextAnnotationImpl.MINIMUM_SIZE.getHeight()));
                        }
                    };
                }
            };
        }

        private void refreshSequenceFlows(DrawableNodeContainer container, FlowNode modelObject) {
            this.refreshFlows(modelObject.getIncomingSequenceFlows(), container, modelObject);
            this.refreshFlows(modelObject.getOutgoingSequenceFlows(), container, modelObject);
        }

        private void refreshFlows(Sequence<SequenceFlow> sequenceFlows, DrawableNodeContainer container, FlowNode modelObject) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                DrawableFlowElement drawable = container.getDrawableFor((Object)sequenceFlow);
                if (drawable == null) continue;
                try {
                    drawable.refresh();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private void refreshChildren(DrawableNodeContainer container, Subprocess modelObject) {
            for (ProjectObject projectObject : modelObject.getChildren()) {
                DrawableFlowElement drawable = container.getDrawableFor((Object)projectObject);
                if (drawable == null) continue;
                try {
                    drawable.refresh();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        private static abstract class ThumbnailFlowNodeCreator<T extends FlowNode>
        extends BpmnDrawableFactory.FlowNodeCreator<T> {
            private ThumbnailFlowNodeCreator(@NotNull Class<T> subtype) {
                super(subtype);
            }

            protected Drawable create(@NotNull DrawableNodeContainer container, @NotNull FlowNode flowNode) {
                return this.subtype(container, flowNode.asAnyNode(this.subtype));
            }
        }
    }
}

