/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.fusion.core.model.PositionableNode;
import oracle.bpm.fusion.ui.action.IdeMenuAdapter;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;
import oracle.ide.controller.ContextMenu;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;

final class ElementNodeFactory {
    private static ElementNodeFactory instance;

    ElementNodeFactory() {
    }

    public static synchronized ElementNodeFactory getInstance() {
        if (instance == null) {
            instance = new ElementNodeFactory();
        }
        return instance;
    }

    public Element create(ProjectObjectTreeNode node) {
        return node == null ? new NullElement() : ElementAdapter.create(node);
    }

    public void adaptActions(Element node, ContextMenu contextMenu) {
        if (node instanceof ElementAdapter) {
            ElementAdapter adapter = (ElementAdapter)node;
            ActionGroup group = adapter.createActions();
            IdeMenuAdapter.adaptActions((ContextMenu)contextMenu, (ActionGroup)group, (Object)adapter.getTreeNode(), (boolean)false);
        }
    }

    public void findNode(Element rootNode, List<ProjectObject> projectObjects) {
    }

    private class NullElement
    implements Element {
        private NullElement() {
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            List elements = Collections.emptyList();
            return elements.iterator();
        }

        public Attributes getAttributes() {
            return DefaultAttributes.EMPTY_ATTRIBUTES;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return "";
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }
    }

    private static class ElementAdapter
    implements Element,
    PositionableNode,
    Adaptable {
        private ProjectObjectTreeNode treeNode;

        public ElementAdapter(ProjectObjectTreeNode node) {
            this.treeNode = node;
        }

        public static Element create(ProjectObjectTreeNode node) {
            return new ElementAdapter(node);
        }

        public boolean mayHaveChildren() {
            return ProjectObjectContainer.class.isAssignableFrom(this.getData().getClass());
        }

        public Iterator<Element> getChildren() {
            List treeNodes = this.treeNode.getChildren();
            ArrayList<Element> children = new ArrayList<Element>();
            for (TreeNode treeNode : treeNodes) {
                children.add(ElementAdapter.create((ProjectObjectTreeNode)treeNode));
            }
            return children.iterator();
        }

        @Override
        public <T> T as(Class<T> targetType) {
            T result = null;
            ProjectObject object = this.treeNode.getUserObject();
            if (object != null) {
                if (targetType.isAssignableFrom(object.getClass())) {
                    result = targetType.cast(object);
                } else if (object instanceof Adaptable) {
                    Adaptable adaptable = (Adaptable)object;
                    result = adaptable.as(targetType);
                }
            }
            return result;
        }

        public Attributes getAttributes() {
            return DefaultAttributes.EMPTY_ATTRIBUTES;
        }

        public Object getData() {
            return this.treeNode.getUserObject();
        }

        public String getShortLabel() {
            return this.treeNode.getText();
        }

        public String getLongLabel() {
            return this.getShortLabel();
        }

        public Icon getIcon() {
            this.treeNode.reloadIcon();
            Image icon = this.treeNode.getIcon();
            return icon != null ? icon.asSwingIcon() : null;
        }

        public String getToolTipText() {
            return this.getShortLabel();
        }

        public ActionGroup createActions() {
            ProjectObject projectObject = this.treeNode.getUserObject();
            return ActionGroup.create((Object)projectObject, (Class)projectObject.getRawClass());
        }

        public int getPosition() {
            return this.treeNode.getUserObject().getPosition();
        }

        public String toString() {
            return this.getShortLabel();
        }

        ProjectObjectTreeNode getTreeNode() {
            return this.treeNode;
        }
    }
}

