/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bpm.fusion.core.BaseNavigatorWindow;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.StudioPreferences;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.util.FileFilter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.navigator.ApplicationChangeNotifier;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.javatools.icons.OracleIcons;

class ProjectNavigatorWindow
extends BaseNavigatorWindow
implements ItemListener,
ApplicationChangeListener,
Controller {
    private MenuToolButton appMenu;
    private JComboBox combo;
    private JPanel mainPanel;
    private Controller projectNavigatorController = new ProjectNavigatorController();
    private Toolbar toolbar;
    private static final String ACTION_INVOKED_FROM_VALUE = "navigatorShortcut";

    ProjectNavigatorWindow(Context context, String viewId) {
        super(context, viewId, FusionStudioMsg.BPM_PROJECT_NAVIGATOR);
    }

    public void applicationChanged(ApplicationChangeEvent e) {
    }

    public Component getGUI() {
        if (this.mainPanel == null) {
            this.mainPanel = this.createMainPanel();
            this.initListeners();
        }
        JPanel result = this.mainPanel;
        return result;
    }

    public String getTabName() {
        return FusionStudioMsg.BPM_NAVIGATOR.getString();
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Controller getController() {
        return this.projectNavigatorController;
    }

    public Context getContext(EventObject event) {
        Context context = super.getContext(event);
        Workspace currentWorkspace = Ide.getActiveWorkspace();
        if (currentWorkspace != null) {
            Project currentProject;
            Node node = context.getNode();
            if (node != null && node.getURL() != null) {
                FusionProjectRepository fusionProjectRepository = (FusionProjectRepository)RepositoryService.getInstance().getActiveRepository();
                currentProject = fusionProjectRepository.getJdevProject(node.getURL());
                context.setElement((Element)node);
            } else {
                currentProject = currentWorkspace.currentActiveProject();
                context.setNode((Node)currentWorkspace);
                context.setElement((Element)currentProject);
            }
            context.setWorkspace(currentWorkspace);
            context.setProject(currentProject);
        } else {
            context.setWorkspace(null);
            context.setProject(null);
        }
        return context;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item;
        if (e.getStateChange() == 1 && (item = e.getItem()) instanceof ApplicationItem) {
            Workspace workspace = ((ApplicationItem)item).getWorkspace();
            JdevRepositoryService.getInstance().applicationChanged(workspace);
            if (workspace != null) {
                Ide.setActiveWorkspace((Workspace)workspace);
                this.changeApplicationNavigatorCombo(workspace);
            }
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    private static Context newWorkspaceContext(Context baseContext) {
        Context context = new Context(baseContext);
        Workspace workspace = baseContext.getWorkspace();
        context.setNode((Node)workspace);
        context.setElement((Element)workspace);
        context.setProject(null);
        return context;
    }

    private void changeApplicationNavigatorCombo(Workspace workspace) {
        JPanel appNavPanel;
        NavigatorManager appNav = NavigatorManager.getApplicationNavigatorManager();
        JComboBox combo = null;
        if (appNav != null && (appNavPanel = (JPanel)appNav.getNavigatorWindow().getGUI()) != null) {
            JComponent applicationNavigatorWindow;
            JComponent appCombo;
            JPanel internPanel;
            if (appNavPanel.getComponentCount() >= 2 && appNavPanel.getComponent(1) instanceof JPanel && (internPanel = (JPanel)appNavPanel.getComponent(1)).getComponentCount() >= 1 && internPanel.getComponent(0) instanceof JComponent && (appCombo = (JComponent)(applicationNavigatorWindow = (JComponent)internPanel.getComponent(0)).getComponent(0)) instanceof JComboBox) {
                combo = (JComboBox)appCombo;
            }
            int index = 0;
            if (combo != null) {
                for (int i = 0; i < combo.getItemCount(); ++i) {
                    if (!(combo.getItemAt(i).toString() + ".jws").equals(workspace.toString())) continue;
                    index = i;
                }
                combo.setSelectedIndex(index);
            }
        }
    }

    private void initListeners() {
        NavigatorManager navigatorManager;
        if (!Product.isBPMStudio()) {
            Ide.getWorkspaces().attach(new Observer(){

                public void update(Object o, UpdateMessage updateMessage) {
                    int id = updateMessage.getMessageID();
                    if (id == UpdateMessage.CHILD_ADDED) {
                        Workspace application = (Workspace)updateMessage.getAddObjects().iterator().next();
                        ProjectNavigatorWindow.this.addApplication(application);
                    } else if (id == UpdateMessage.CHILD_REMOVED) {
                        Workspace application = (Workspace)updateMessage.getRemoveObjects().iterator().next();
                        ProjectNavigatorWindow.this.removeApplication(application);
                    }
                    ProjectNavigatorWindow.this.appMenu.setVisible(Ide.getWorkspaces().size() > 0);
                }
            });
        }
        if ((navigatorManager = NavigatorManager.getApplicationNavigatorManager()) != null) {
            ApplicationChangeNotifier navigatorWindow = (ApplicationChangeNotifier)navigatorManager.getNavigatorWindow();
            navigatorWindow.addApplicationChangeListener(new ApplicationChangeListener(){

                public void applicationChanged(ApplicationChangeEvent event) {
                    if (event.getStateChange() == 2) {
                        Workspace application = event.getApplication();
                        ApplicationItem item = new ApplicationItem(application);
                        ProjectNavigatorWindow.this.combo.setToolTipText(application.getURL().toString());
                        ProjectNavigatorWindow.this.combo.setSelectedItem(item);
                    }
                }
            });
        }
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        this.combo = new JComboBox();
        this.combo.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof ApplicationItem) {
                    String name = ((ApplicationItem)value).getName();
                    return new JLabel(name);
                }
                String s = value != null ? value.toString() : FusionStudioMsg.NO_APPLICATION.getString();
                return new JLabel(s);
            }
        });
        ToggleAction nopAction = new ToggleAction(FusionStudioMsg.APPLICATION_MENU.toString(), ModelArb.getIcon((int)12)){
            static final long serialVersionUID = 0L;

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.appMenu = new AppMenuToolButton(nopAction);
        this.appMenu.setVisible(Ide.getWorkspaces().size() > 0);
        Iterator workspaces = Ide.getWorkspaces().getChildren();
        while (workspaces.hasNext()) {
            Workspace w = (Workspace)workspaces.next();
            this.combo.addItem(new ApplicationItem(w));
        }
        Workspace activeWorkspace = Ide.getActiveWorkspace();
        if (activeWorkspace != null) {
            this.combo.setSelectedItem(new ApplicationItem(activeWorkspace));
        } else {
            this.combo.setSelectedItem(-1);
        }
        this.combo.addItemListener(this);
        Icon openAppIcon = OracleIcons.getIcon((String)"open.png");
        Icon newAppIcon = OracleIcons.getIcon((String)"newApplication.png");
        OpenAppAction openAppAction = new OpenAppAction(FusionStudioMsg.OPEN_APPLICATION.toString(), openAppIcon);
        NewAppAction newAppAction = new NewAppAction(FusionStudioMsg.NEW_APPLICATION.toString(), newAppIcon);
        this.toolbar = new Toolbar();
        this.toolbar.setPrimaryViewToolbar(true);
        this.toolbar.add((Component)this.combo);
        this.toolbar.addSeparator();
        this.toolbar.add((Action)openAppAction);
        this.toolbar.add((Action)newAppAction);
        this.toolbar.add((Component)this.appMenu);
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.toolbar, "North");
        Component component = super.getGUI();
        mainPanel.add(component, "Center");
        mainPanel.setOpaque(false);
        return mainPanel;
    }

    private void invokeCreateNewApplication() {
        NewWorkspacePanel panel = new NewWorkspacePanel(false, false, true);
        boolean result = panel.runDialog();
        if (result) {
            URL url = panel.getFileURL();
            Workspace workspace = new Workspace();
            workspace.setURL(url);
            try {
                Project p = new Project();
                p.setURL(new URL(url, "BPMProject1"));
                workspace.add((Element)p);
                workspace.save();
                workspace.remove((Element)p);
                workspace.save();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.selectWorkspace(workspace);
        }
    }

    private void invokeOpenApplication() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(FileFilter.create(FusionStudioMsg.APPLICATION_FILE, ".jws"));
        chooser.setSelectedFile(new File(Ide.getWorkDirectory()));
        int result = chooser.showOpenDialog(null);
        if (result == 0) {
            File selectedFile = chooser.getSelectedFile();
            try {
                Workspace workspace = new Workspace();
                workspace.setURL(selectedFile.toURI().toURL());
                workspace.open();
                this.selectWorkspace(workspace);
            }
            catch (MalformedURLException ignore) {
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    private void selectWorkspace(Workspace workspace) {
        Ide.getWorkspaces().add((Element)workspace);
        Ide.setActiveWorkspace((Workspace)workspace);
        this.updatePreferences();
        JdevRepositoryService.getInstance().applicationChanged(workspace);
        this.addApplication(workspace);
        IdeMainWindow.updateVisibleActions();
    }

    private void addApplication(Workspace workspace) {
        ApplicationItem item = new ApplicationItem(workspace);
        this.combo.setToolTipText(workspace.getURL().toString());
        this.combo.addItem(item);
        this.combo.setSelectedItem(item);
    }

    private void removeApplication(Workspace workspace) {
        ApplicationItem item = new ApplicationItem(workspace);
        this.combo.removeItem(item);
    }

    private void updatePreferences() {
        StudioPreferences studioPreferences = StudioPreferences.getPreferences();
        studioPreferences.setActiveWorkspace(Ide.getActiveWorkspace().getURL().toString());
        Iterator children = Ide.getWorkspaces().getChildren();
        studioPreferences.getWorkspaces().clear();
        while (children.hasNext()) {
            studioPreferences.getWorkspaces().add(((Workspace)children.next()).getURL().toString());
        }
        studioPreferences.store();
    }

    private final class ProjectNavigatorController
    implements Controller {
        private ProjectNavigatorController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }

    private class OpenAppAction
    extends AbstractAction {
        static final long serialVersionUID = 0L;

        public OpenAppAction(String s, Icon icon) {
            super(s, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!Product.isBPMStudio()) {
                        String openAppCmd = "ContentSetSupport.ADD_TO_PROJECT_CMD_ID";
                        IdeAction action = IdeAction.find((String)"ContentSetSupport.ADD_TO_PROJECT_CMD_ID");
                        if (action != null) {
                            try {
                                Workspaces workspaces = Ide.getWorkspaces();
                                Context context = ProjectNavigatorWindow.this.getContext();
                                context.setElement((Element)workspaces);
                                context.setWorkspace(null);
                                context.setProject(null);
                                context.setNode(null);
                                action.putValue("invokedFrom", (Object)ProjectNavigatorWindow.ACTION_INVOKED_FROM_VALUE);
                                action.performAction(context);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        ProjectNavigatorWindow.this.invokeOpenApplication();
                    }
                }
            });
        }
    }

    private class NewAppAction
    extends AbstractAction {
        static final long serialVersionUID = 0L;

        public NewAppAction(String s, Icon icon) {
            super(s, icon);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!Product.isBPMStudio()) {
                        String newAppCmd = "oracle.jdeveloper.cmd.NewApplicationCommand";
                        IdeAction action = IdeAction.find((String)"oracle.jdeveloper.cmd.NewApplicationCommand");
                        if (action != null) {
                            try {
                                action.putValue("invokedFrom", (Object)ProjectNavigatorWindow.ACTION_INVOKED_FROM_VALUE);
                                action.performAction(ProjectNavigatorWindow.this.getContext());
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    } else {
                        ProjectNavigatorWindow.this.invokeCreateNewApplication();
                    }
                }
            });
        }
    }

    private class DummyCommand
    extends CloseNodeCommand {
        private ArrayList<Project> nodes;

        public DummyCommand(ArrayList<Project> nodes) {
            this.nodes = nodes;
        }

        public void collectNodes(List dirtyNodes) {
            this.collectDirtyNodes(this.nodes.iterator(), dirtyNodes);
        }
    }

    private class AppMenuToolButton
    extends MenuToolButton {
        private PopupMenuListener _popupMenuListener;
        private JMenuItem closeAppMenuItem;
        private JMenuItem deleteAppMenuItem;
        static final long serialVersionUID = 0L;

        public AppMenuToolButton(ToggleAction nopAction) {
            super(nopAction);
            this.setToolTipText(FusionStudioMsg.APPLICATION_MENU.toString());
            this._popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    AppMenuToolButton.this.removePML();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
        }

        protected JPopupMenu createPopupMenu() {
            this._popup = (JPopupMenu)ProjectNavigatorWindow.this.getContextMenu().getGUI(true);
            this.closeAppMenuItem = new JMenuItem((Action)new BaseAction(FusionStudioMsg.CLOSE_APPLICATION, FusionStudioMsg.CLOSE_APPLICATION.toString()){

                public void run() {
                    try {
                        Context context = ProjectNavigatorWindow.newWorkspaceContext(ProjectNavigatorWindow.this.getContext());
                        IdeActions.getFileCloseAction().performAction(context);
                        ProjectNavigatorWindow.this.removeApplication(context.getWorkspace());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            BaseAction action1 = new BaseAction(FusionStudioMsg.DELETE_APPLICATION, FusionStudioMsg.DELETE_APPLICATION.toString()){

                public void run() {
                    try {
                        Context context = ProjectNavigatorWindow.newWorkspaceContext(ProjectNavigatorWindow.this.getContext());
                        IdeActions.getFileRemoveFromDiskAction().performAction(context);
                        ProjectNavigatorWindow.this.removeApplication(context.getWorkspace());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            action1.putValue("SmallIcon", (Object)IdeArb.getIcon((int)103));
            this.deleteAppMenuItem = new JMenuItem((Action)action1);
            return this._popup;
        }

        protected ItemListener createButtonItemListener() {
            final ItemListener superListener = super.createButtonItemListener();
            return new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Context context = ProjectNavigatorWindow.this.getContext();
                    Workspace workspace = context.getWorkspace();
                    context.setElement((Element)workspace);
                    ProjectNavigatorWindow.this.getGUI().requestFocus();
                    context.setProject(null);
                    context.setNode((Node)workspace);
                    if (!Product.isBPMStudio()) {
                        ProjectNavigatorWindow.this.getContextMenu().prepareShow(context);
                    } else {
                        ProjectNavigatorWindow.this.getContextMenu().add((Component)AppMenuToolButton.this.closeAppMenuItem);
                        ProjectNavigatorWindow.this.getContextMenu().add((Component)AppMenuToolButton.this.deleteAppMenuItem);
                    }
                    AppMenuToolButton.this._popup.addPopupMenuListener(AppMenuToolButton.this._popupMenuListener);
                    superListener.itemStateChanged(e);
                }
            };
        }

        private void removePML() {
            this.getModel().setArmed(false);
            this.setSelected(false);
            this._popup.removePopupMenuListener(this._popupMenuListener);
        }
    }

    private final class ApplicationItem {
        private Workspace workspace;

        public ApplicationItem(Workspace workspace) {
            this.workspace = workspace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationItem that = (ApplicationItem)o;
            return !(this.workspace == null || this.workspace.getURL() == null ? that.workspace != null : that.workspace.getURL() != null && !this.workspace.getURL().toString().equals(that.workspace.getURL().toString()));
        }

        public int hashCode() {
            return this.workspace != null && this.workspace.getURL() != null ? this.workspace.getURL().toString().hashCode() : 0;
        }

        public String getName() {
            String name = this.workspace.getShortLabel();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            return name;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }
    }
}

