/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.panels;

import java.util.Collection;
import java.util.Comparator;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.designer.simulation.ModelSimulationInstancePanel;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class ProcessSimulationComponentPanel
extends Panel
implements EditableComponent<Process> {
    private Process element;
    private ModelSimulationInstancePanel instancePanel;
    private ComboBox<ModelSimulation> modelSimulationCombo;
    private ItemListener simulationsComboListener;

    public ProcessSimulationComponentPanel(@NotNull UiContainer parent, @NotNull Process element) {
        super(parent);
        this.element = element;
        this.buildUi();
    }

    public ModelSimulationInstancePanel getInstancePanel() {
        return this.instancePanel;
    }

    public void validateEditor() throws ProjectException {
        this.instancePanel.validateEditor();
    }

    public void applyChanges() {
        this.instancePanel.applyChanges();
    }

    public void populateValues() {
        this.modelSimulationCombo.removeItemListener(this.getModelSimulationChangeListener());
        this.modelSimulationCombo.setSelectedItem(null);
        this.modelSimulationCombo.removeAllItems();
        Collection<ModelSimulation> modelSimulations = this.getModelSimulations();
        this.modelSimulationCombo.addItems(modelSimulations);
        if (!modelSimulations.isEmpty()) {
            this.modelSimulationCombo.setSelectedIndex(0);
            this.instancePanel.setElement((ModelSimulation)this.modelSimulationCombo.getSelectedItem());
            this.instancePanel.populateValues();
            this.modelSimulationCombo.addItemListener(this.getModelSimulationChangeListener());
        }
    }

    public void loadValues() {
        this.instancePanel.loadValues();
    }

    public UiComponent getUiComponent() {
        return this;
    }

    public Process getElement() {
        return this.element;
    }

    public boolean isDirty() {
        return false;
    }

    public void setElement(Process element) {
        this.element = element;
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout());
        Panel simulationsPanel = new Panel((UiContainer)this);
        simulationsPanel.setLayout((Layout)new FlowLayout(0));
        this.modelSimulationCombo = UiFactory.createComboBox((UiContainer)simulationsPanel);
        simulationsPanel.add((UiComponent)Label.create((UiContainer)simulationsPanel, (Msg)DesignerMsg.SIMULATION_MODELS));
        simulationsPanel.add(this.modelSimulationCombo);
        this.instancePanel = new ModelSimulationInstancePanel((UiContainer)this, null);
        this.add((UiComponent)simulationsPanel, "North");
        this.add((UiComponent)this.instancePanel, "Center");
        this.populateValues();
    }

    private ItemListener getModelSimulationChangeListener() {
        if (this.simulationsComboListener == null) {
            this.simulationsComboListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ProcessSimulationComponentPanel.this.instancePanel.setElement((ModelSimulation)ProcessSimulationComponentPanel.this.modelSimulationCombo.getSelectedItem());
                    ProcessSimulationComponentPanel.this.instancePanel.populateValues();
                }
            };
        }
        return this.simulationsComboListener;
    }

    private Collection<ModelSimulation> getModelSimulations() {
        Sequence simulationsSequence = this.getElement().getProject().getSimulations().getModelSimulationsByProcess(this.getElement());
        return CollectionUtils.sort(simulationsSequence, new Comparator<ModelSimulation>(){

            @Override
            public int compare(ModelSimulation modelSimulation, ModelSimulation modelSimulation1) {
                return modelSimulation.getId().compareTo(modelSimulation1.getId());
            }
        });
    }
}

