/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.panels;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;

public class ProcessGeneralComponentPanel
extends Panel
implements EditableComponent<Process> {
    private TextField authorTextField;
    private TextField nameTextField;
    private Process process;

    public ProcessGeneralComponentPanel(UiContainer parent, Process process) {
        super(parent);
        this.process = process;
        this.buildUi();
    }

    public void validateEditor() throws ProjectException {
        if (Str.isEmpty(this.nameTextField.getText())) {
            this.nameTextField.setText(this.getElement().getDefaultLabel());
            throw new ProjectException((ProjectObject)this.getElement());
        }
    }

    public void applyChanges() {
        this.process.setDefaultLabel(this.nameTextField.getText());
        this.process.setAuthor(this.authorTextField.getText());
    }

    public void populateValues() {
        this.loadValues();
    }

    public void loadValues() {
        this.nameTextField.setText(this.process.getDefaultLabel());
        this.authorTextField.setText(this.process.getAuthor());
    }

    public boolean isDirty() {
        return !this.nameTextField.getText().equals(this.process.getDefaultLabel()) || !this.authorTextField.getText().equals(this.process.getAuthor());
    }

    public String getHelpId() {
        return "";
    }

    public UiComponent getUiComponent() {
        return this;
    }

    public Process getElement() {
        return this.process;
    }

    public void setElement(Process element) {
        this.process = element;
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fillx"));
        this.nameTextField = new TextField((UiContainer)this);
        this.authorTextField = new TextField((UiContainer)this);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
        this.add((UiComponent)this.nameTextField, "growx, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectMsg.AUTHOR));
        this.add((UiComponent)this.authorTextField, "growx, wrap");
        this.populateValues();
    }
}

