/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.panels;

import java.util.Collection;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.designer.simulation.ActivitiesPanel;
import oracle.bpm.designer.simulation.ModelSimulationInstancePanel;
import oracle.bpm.fusion.studio.inspector.panels.SimulationEditableComponent;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class FlowNodeSimulationDetailPanel
extends Panel
implements SimulationEditableComponent {
    private ActivitiesPanel.ActivityCardPanel activityCardPanel;
    private FlowNode element;
    private ModelSimulationInstancePanel instancePanel;
    private ModelSimulation modelSimulation;

    public FlowNodeSimulationDetailPanel(@NotNull UiContainer parent, @NotNull FlowNode element) {
        super(parent);
        this.element = element;
        this.buildUi();
    }

    public void validateEditor() throws ProjectException {
        this.instancePanel.validateEditor();
        this.activityCardPanel.validateEditor();
    }

    public void applyChanges() {
        this.instancePanel.applyChanges();
        this.activityCardPanel.applyChanges();
    }

    public void populateValues() {
        Collection<ModelSimulation> modelSimulations = this.getModelSimulations();
        if (!modelSimulations.isEmpty()) {
            this.instancePanel.setElement(this.modelSimulation);
            this.instancePanel.populateValues();
            this.activityCardPanel.setModelSimulation(this.modelSimulation);
            this.activityCardPanel.populateValues();
        }
    }

    public void loadValues() {
        this.instancePanel.loadValues();
        this.activityCardPanel.loadValues();
    }

    public UiComponent getUiComponent() {
        return this;
    }

    public FlowNode getElement() {
        return this.element;
    }

    public boolean isDirty() {
        return this.instancePanel.isDirty() || this.activityCardPanel.isDirty();
    }

    public void setElement(FlowNode element) {
        this.activityCardPanel.setElement(element);
    }

    @Override
    public void changeSimulation(ModelSimulation modelSimulation) {
        this.modelSimulation = modelSimulation;
        this.instancePanel.setElement(modelSimulation);
        this.activityCardPanel.setModelSimulation(modelSimulation);
    }

    private void buildUi() {
        this.setLayout((Layout)new BorderLayout());
        this.instancePanel = new ModelSimulationInstancePanel((UiContainer)this, null);
        FlowNodeInformationPanel flowNodeInformationPanel = new FlowNodeInformationPanel((UiContainer)this);
        this.add((UiComponent)this.instancePanel, "North");
        this.add((UiComponent)flowNodeInformationPanel, "Center");
    }

    private Collection<ModelSimulation> getModelSimulations() {
        Process process = this.getElement().getProcess();
        Sequence simulationsSequence = this.getElement().getProject().getSimulations().getModelSimulationsByProcess(process);
        return SequenceBuilder.create(simulationsSequence).toCollection();
    }

    private class FlowNodeInformationPanel
    extends Panel {
        public FlowNodeInformationPanel(UiContainer parent) {
            super(parent, FusionStudioMsg.FLOW_NODE_INFORMATION);
            this.buildUi();
        }

        private void buildUi() {
            this.setLayout((Layout)new BorderLayout());
            FlowNodeSimulationDetailPanel.this.activityCardPanel = new ActivitiesPanel.ActivityCardPanel((UiContainer)this);
            FlowNodeSimulationDetailPanel.this.activityCardPanel.setElement(FlowNodeSimulationDetailPanel.this.getElement());
            this.add((UiComponent)FlowNodeSimulationDetailPanel.this.activityCardPanel, "Center");
        }
    }
}

