/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.panels;

import oracle.bpm.designer.flowpanels.ActivityGenerateEventsFeatureEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.exceptions.ActivityHasNoNameException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;

public class FlowNodeGeneralComponentPanel
extends Panel
implements EditableComponent<FlowNode> {
    private FlowNode flowNode;
    private ActivityGenerateEventsFeatureEditor generateEventsEditableComponent;
    private TextField nameTextField;

    public FlowNodeGeneralComponentPanel(UiContainer parent, FlowNode flowNode) {
        super(parent);
        this.flowNode = flowNode;
        this.buildUi();
    }

    public void validateEditor() throws ProjectException {
        if (Str.isEmpty(this.nameTextField.getText())) {
            this.nameTextField.setText(this.getElement().getDefaultLabel());
            throw new ActivityHasNoNameException(this.getElement());
        }
    }

    public void applyChanges() {
        this.getElement().setDefaultLabel(this.nameTextField.getText());
        this.generateEventsEditableComponent.applyChanges();
    }

    public void populateValues() {
        this.loadValues();
        this.generateEventsEditableComponent.populateValues();
    }

    public void loadValues() {
        this.nameTextField.setText(this.flowNode.getDefaultLabel());
        this.generateEventsEditableComponent.loadValues();
    }

    public boolean isDirty() {
        return !this.nameTextField.getText().equals(this.flowNode.getDefaultLabel()) || this.generateEventsEditableComponent.isDirty();
    }

    public String getHelpId() {
        return "";
    }

    public UiComponent getUiComponent() {
        return this;
    }

    public FlowNode getElement() {
        return this.flowNode;
    }

    public void setElement(FlowNode element) {
        this.flowNode = element;
        this.generateEventsEditableComponent.setElement(element);
    }

    private void buildUi() {
        this.setLayout((Layout)new MigLayout("fillx"));
        this.nameTextField = new TextField((UiContainer)this);
        this.generateEventsEditableComponent = new ActivityGenerateEventsFeatureEditor((UiContainer)this, this.getElement(), true);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
        this.add((UiComponent)this.nameTextField, "growx, wrap");
        this.add(this.generateEventsEditableComponent.getUiComponent(), "growx, dock south");
        this.populateValues();
    }
}

