/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component.builder;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.designer.panels.builder.EditableComponentPanel;
import oracle.bpm.designer.panels.builder.EditorPanelBuilder;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.LineBorder;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

public class ImplementationTypeEditorBuilder<E extends FlowNode>
implements EditorPanelBuilder<E> {
    private boolean showLabel;
    public static Msg LABEL_MSG = DesignerMsg.TASK_TYPE;

    private ImplementationTypeEditorBuilder(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public static synchronized ImplementationTypeEditorBuilder create(boolean showLabel) {
        return new ImplementationTypeEditorBuilder(showLabel);
    }

    public static synchronized ImplementationTypeEditorBuilder create() {
        return new ImplementationTypeEditorBuilder(true);
    }

    public EditableComponent<E> build(UiContainer parent, E element) {
        EditableComponentPanel mainPanel = new EditableComponentPanel(parent, element);
        mainPanel.setLayout((Layout)new MigLayout("fill"));
        Panel elementTypePanel = new Panel((UiContainer)mainPanel);
        elementTypePanel.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        elementTypePanel.setBorder(LineBorder.createGrayLineBorder());
        Label label = Label.createWithNoColon((UiContainer)elementTypePanel, (Msg)Msg.QUOTE(""));
        Msg text = Msg.QUOTE(element.getBpmnType().getString());
        label.setText(text);
        label.setIcon(ImplementationTypeEditorBuilder.getImage(element));
        elementTypePanel.add((UiComponent)label, (Object)"gapx 2, gaptop 2px, grow");
        if (this.showLabel) {
            mainPanel.add((UiComponent)Label.create((UiContainer)elementTypePanel, (Msg)DesignerMsg.TASK_TYPE));
        }
        mainPanel.add((UiComponent)elementTypePanel, (Object)"growx");
        return mainPanel;
    }

    private static Image getImage(FlowNode flowNode) {
        FlowFigureType flowFigureType = FlowFigureUtils.fromType((BpmnType)flowNode.getBpmnType());
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        return theme.getImageFor(flowFigureType, ImageType.MINI_ICON);
    }
}

