/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component.builder;

import oracle.bpm.designer.flowpanels.SoaUserTaskRowEditorBuilder;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.designer.panels.builder.EditableComponentPanel;
import oracle.bpm.designer.panels.builder.EditorPanelBuilder;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.HumanTaskType;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

public class HumanTaskBuilder
implements EditorPanelBuilder<UserTask> {
    private SoaUserTaskRowEditorBuilder humanTaskPanelBuilder;
    private boolean showLabel;

    public HumanTaskBuilder(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public static HumanTaskBuilder create(boolean showLabel) {
        return new HumanTaskBuilder(showLabel);
    }

    public EditableComponent<UserTask> build(UiContainer parent, UserTask userTask) {
        HumanTaskType humanTaskTypeFilter = null;
        HumanTask humanTask = userTask.getHumanTask();
        if (!userTask.getHumanTaskType().isDefault() && humanTask == null) {
            humanTaskTypeFilter = userTask.getHumanTaskType();
        }
        ProjectFilters.HumanTaskFilter humanTaskFilter = ProjectFilters.HumanTaskFilter.create(humanTaskTypeFilter);
        this.humanTaskPanelBuilder = new SoaUserTaskRowEditorBuilder(ProjectModelMsg.HUMAN_TASK, (ProjectFilter)humanTaskFilter, userTask);
        EditableComponentPanel<UserTask> panel = new EditableComponentPanel<UserTask>(parent, userTask){

            public void applyChanges() {
                if (HumanTaskBuilder.this.humanTaskPanelBuilder.isDirty()) {
                    HumanTaskBuilder.this.humanTaskPanelBuilder.applyChanges();
                }
            }

            public boolean isDirty() {
                return HumanTaskBuilder.this.humanTaskPanelBuilder.isDirty();
            }

            public void validateEditor() throws ProjectException {
            }

            public void populateValues() {
                this.loadValues();
            }

            public void loadValues() {
                HumanTaskBuilder.this.humanTaskPanelBuilder.setUserTask((UserTask)this.getElement());
            }
        };
        panel.setLayout((Layout)new MigLayout("fillx"));
        if (this.showLabel) {
            panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)ProjectModelMsg.HUMAN_TASK));
        }
        panel.add(this.humanTaskPanelBuilder.createEditor((UiContainer)panel), (Object)"growx");
        return panel;
    }
}

