/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component.builder;

import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.designer.panels.builder.EditableComponentPanel;
import oracle.bpm.fusion.studio.inspector.component.builder.ImplementationTypeEditorBuilder;
import oracle.bpm.fusion.studio.inspector.panels.FlowNodeGeneralComponentPanel;
import oracle.bpm.fusion.studio.inspector.panels.FlowNodeSimulationDetailPanel;
import oracle.bpm.fusion.studio.inspector.panels.SimulationEditableComponent;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.Cast;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public abstract class FlowNodePIEditorPanelBuilder<E extends FlowNode> {
    @NotNull
    public EditableComponent<FlowNode> buildGeneralPanel(UiContainer parent, E element) {
        FlowNodeGeneralComponentPanel panel = new FlowNodeGeneralComponentPanel(parent, (FlowNode)element);
        return panel;
    }

    @NotNull
    public EditableComponent<E> buildImplementationPanel(UiContainer parent, E element) {
        ImplementationTypeEditorBuilder builder = (ImplementationTypeEditorBuilder)Cast.force(ImplementationTypeEditorBuilder.create());
        return builder.build(parent, element);
    }

    @NotNull
    public EditableComponent<E> buildDataAssociationsPanel(UiContainer parent, E element) {
        EditableComponentPanel editableComponentPanel = new EditableComponentPanel(parent, element);
        UiContainer uiPanel = (UiContainer)editableComponentPanel.getUiComponent();
        uiPanel.add((UiComponent)Label.createWithNoColon((UiContainer)uiPanel, (Msg)FusionStudioMsg.NO_DATA_ASSOCIATIONS_AVAILABLE));
        return editableComponentPanel;
    }

    @NotNull
    public SimulationEditableComponent buildSimulationPanel(UiContainer parent, FlowNode element) {
        return new FlowNodeSimulationDetailPanel(parent, element);
    }
}

