/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Method;
import oracle.bpm.fusion.studio.inspector.component.AbstractFocusChangeListener;
import oracle.bpm.fusion.studio.inspector.component.FocusChangeListener;

public class WeakFocusChangeListener
implements PropertyChangeListener,
VetoableChangeListener {
    private Object src;
    private WeakReference weakReference;

    public WeakFocusChangeListener(FocusChangeListener focusChangeListener, Object src) {
        this.src = src;
        this.weakReference = new WeakReference(focusChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        FocusChangeListener focusChangeListener = (FocusChangeListener)this.weakReference.get();
        if (focusChangeListener != null) {
            focusChangeListener.propertyChange(evt);
        } else {
            this.removeFocusListener();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        AbstractFocusChangeListener focusChangeListener = (AbstractFocusChangeListener)this.weakReference.get();
        if (focusChangeListener != null) {
            focusChangeListener.vetoableChange(evt);
        } else {
            this.removeFocusListener();
        }
    }

    private void removeFocusListener() {
        try {
            Method removePropertyListenerMethod = this.src.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            removePropertyListenerMethod.invoke(this.src, this);
            Method removeVetoableListenerMethod = this.src.getClass().getMethod("removeVetoableChangeListener", PropertyChangeListener.class);
            removeVetoableListenerMethod.invoke(this.src, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class WeakReference {
        private Object o;

        private WeakReference(Object o) {
            this.o = o;
        }

        public Object get() {
            return this.o;
        }
    }
}

