/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component;

import java.util.Collection;
import java.util.Comparator;
import oracle.bali.inspector.PropertyModel;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.fusion.studio.inspector.component.BpmGUIComponent;
import oracle.bpm.fusion.studio.inspector.panels.ProcessSimulationComponentPanel;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import org.jetbrains.annotations.NotNull;

public class ProcessSimulationGUIComponent
extends BpmGUIComponent<Process> {
    private Panel piNoSimulationPanel;
    private ProcessSimulationComponentPanel processSimulationDetailPanel;
    private EditableComponent<Process> processSimulationsCardPanel;
    private CardLayout simulationPanelCardLayout;
    private static final String SIMULATION_DETAIL_PANEL = "SimulationDetailPanel";
    private static final String NO_SIMULATION_PANEL = "NoSimulationPanel";

    @Override
    @NotNull
    public EditableComponent<Process> buildCustomPanel(UiContainer mainParent, Process element) {
        this.processSimulationsCardPanel = new ProcessSimulationCardPanel(mainParent);
        this.simulationPanelCardLayout = new CardLayout();
        UiContainer processSimCardPanelContainer = (UiContainer)this.processSimulationsCardPanel.getUiComponent();
        processSimCardPanelContainer.setLayout((Layout)this.simulationPanelCardLayout);
        this.piNoSimulationPanel = new Panel(processSimCardPanelContainer);
        this.piNoSimulationPanel.add((UiComponent)Label.createWithNoColon((UiContainer)this.piNoSimulationPanel, (Msg)FusionStudioMsg.NO_SIMULATIONS_FOR_PROCESS));
        processSimCardPanelContainer.add((UiComponent)this.piNoSimulationPanel, (Object)NO_SIMULATION_PANEL);
        this.processSimulationDetailPanel = new ProcessSimulationComponentPanel(processSimCardPanelContainer, element);
        processSimCardPanelContainer.add((UiComponent)this.processSimulationDetailPanel, (Object)SIMULATION_DETAIL_PANEL);
        if (this.getModelSimulations(element).isEmpty()) {
            this.simulationPanelCardLayout.show(processSimCardPanelContainer, NO_SIMULATION_PANEL);
        } else {
            this.simulationPanelCardLayout.show(processSimCardPanelContainer, SIMULATION_DETAIL_PANEL);
        }
        return this.processSimulationsCardPanel;
    }

    @Override
    public void onUpdate(PropertyModel model) {
        super.onUpdate(model);
        UiContainer processSimCardPanelContainer = (UiContainer)this.processSimulationsCardPanel.getUiComponent();
        if (this.getModelSimulations((Process)this.getElement(model)).isEmpty()) {
            this.simulationPanelCardLayout.show(processSimCardPanelContainer, NO_SIMULATION_PANEL);
        } else {
            this.simulationPanelCardLayout.show(processSimCardPanelContainer, SIMULATION_DETAIL_PANEL);
        }
    }

    @Override
    protected EditableComponent getFocusablePanel() {
        return this.processSimulationDetailPanel.getInstancePanel();
    }

    private Collection<ModelSimulation> getModelSimulations(Process process) {
        Sequence simulationsSequence = process.getProject().getSimulations().getModelSimulationsByProcess(process);
        return CollectionUtils.sort(simulationsSequence, new Comparator<ModelSimulation>(){

            @Override
            public int compare(ModelSimulation simulation1, ModelSimulation simulation2) {
                return simulation1.getName().compareTo(simulation2.getName());
            }
        });
    }

    private class ProcessSimulationCardPanel
    extends Panel
    implements EditableComponent<Process> {
        public ProcessSimulationCardPanel(UiContainer parent) {
            super(parent);
        }

        public void setElement(Process element) {
            ProcessSimulationGUIComponent.this.processSimulationDetailPanel.setElement(element);
        }

        public void validateEditor() throws ProjectException {
            ProcessSimulationGUIComponent.this.processSimulationDetailPanel.validateEditor();
        }

        public void applyChanges() {
            ProcessSimulationGUIComponent.this.processSimulationDetailPanel.applyChanges();
        }

        public void populateValues() {
            ProcessSimulationGUIComponent.this.processSimulationDetailPanel.populateValues();
        }

        public void loadValues() {
            ProcessSimulationGUIComponent.this.processSimulationDetailPanel.loadValues();
        }

        public UiComponent getUiComponent() {
            return this;
        }

        public Process getElement() {
            return ProcessSimulationGUIComponent.this.processSimulationDetailPanel.getElement();
        }

        public boolean isDirty() {
            return false;
        }
    }
}

