/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component;

import java.awt.KeyboardFocusManager;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.fusion.studio.inspector.component.AbstractFocusChangeListener;
import oracle.bpm.fusion.studio.inspector.component.BpmGUIComponent;
import oracle.bpm.fusion.studio.inspector.component.WeakFocusChangeListener;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.project.model.exception.ProjectException;

public class InspectorFocusTrackerHandler {
    private static InspectorFocusTrackerHandler instance;
    private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";

    private InspectorFocusTrackerHandler() {
    }

    public static synchronized InspectorFocusTrackerHandler getInstance() {
        if (instance == null) {
            instance = new InspectorFocusTrackerHandler();
        }
        return instance;
    }

    public void startListeningFocus(BpmGUIComponent guiComponent) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.clearGlobalFocusOwner();
        Object focusableComponent = guiComponent.getGUIPanel().getFocusableComponent();
        if (!(focusableComponent instanceof EditableComponent)) {
            throw new ProgramException("WARNING: Focusable component of BpmGUIComponent must be instance of EditableComponent.");
        }
        EditableComponent rootComponent = (EditableComponent)focusableComponent;
        AbstractFocusChangeListener focusOwnerTracker = new AbstractFocusChangeListener(rootComponent){

            @Override
            protected void focusLost() {
                if (this.getEditableComponent().isDirty()) {
                    this.getEditableComponent().applyChanges();
                }
            }

            @Override
            protected boolean shouldVetoOnFocusLost() {
                try {
                    this.getEditableComponent().validateEditor();
                    return false;
                }
                catch (ProjectException e) {
                    return true;
                }
            }

            @Override
            protected void focusGained() {
            }
        };
        WeakFocusChangeListener weakFocusChangeListener = new WeakFocusChangeListener(focusOwnerTracker, focusManager);
        focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER, weakFocusChangeListener);
        focusManager.addVetoableChangeListener(PERMANENT_FOCUS_OWNER, weakFocusChangeListener);
    }
}

