/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component;

import java.util.Collection;
import java.util.Comparator;
import oracle.bali.inspector.PropertyModel;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.fusion.studio.inspector.component.BpmGUIComponent;
import oracle.bpm.fusion.studio.inspector.component.builder.BpmnTypePIPanelBuilderProvider;
import oracle.bpm.fusion.studio.inspector.component.builder.FlowNodePIEditorPanelBuilder;
import oracle.bpm.fusion.studio.inspector.panels.SimulationEditableComponent;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class FlowNodeSimulationGUIComponent
extends BpmGUIComponent<FlowNode> {
    private SimulationEditableComponent flowNodeSimulationDetailPanel;
    private FlowNodeSimulationCardPanel flowNodeSimulationsCardPanel;
    private ComboBox<ModelSimulation> modelSimulationCombo;
    private Panel piNoSimulationPanel;
    private CardLayout simulationPanelCardLayout;
    private ItemListener simulationsComboListener;
    private static final String SIMULATION_DETAIL_PANEL = "SimulationDetailPanel";
    private static final String NO_SIMULATION_PANEL = "NoSimulationPanel";

    @Override
    @NotNull
    public EditableComponent<FlowNode> buildCustomPanel(UiContainer mainParent, FlowNode element) {
        this.flowNodeSimulationsCardPanel = new FlowNodeSimulationCardPanel(mainParent);
        this.simulationPanelCardLayout = new CardLayout();
        this.flowNodeSimulationsCardPanel.setLayout((Layout)this.simulationPanelCardLayout);
        this.piNoSimulationPanel = new Panel((UiContainer)this.flowNodeSimulationsCardPanel);
        this.piNoSimulationPanel.add((UiComponent)Label.createWithNoColon((UiContainer)this.piNoSimulationPanel, (Msg)FusionStudioMsg.NO_SIMULATIONS_FOR_PROCESS));
        this.flowNodeSimulationsCardPanel.add((UiComponent)this.piNoSimulationPanel, NO_SIMULATION_PANEL);
        Panel flowNodeSimulationPanel = this.buildSimulationPanel(element);
        this.flowNodeSimulationsCardPanel.add((UiComponent)flowNodeSimulationPanel, SIMULATION_DETAIL_PANEL);
        if (this.getModelSimulations(element).isEmpty()) {
            this.simulationPanelCardLayout.show((UiContainer)this.flowNodeSimulationsCardPanel, NO_SIMULATION_PANEL);
        } else {
            this.simulationPanelCardLayout.show((UiContainer)this.flowNodeSimulationsCardPanel, SIMULATION_DETAIL_PANEL);
        }
        this.flowNodeSimulationsCardPanel.populateValues();
        return this.flowNodeSimulationsCardPanel;
    }

    @Override
    protected EditableComponent getFocusablePanel() {
        return this.flowNodeSimulationDetailPanel;
    }

    private Panel buildSimulationPanel(FlowNode flowNode) {
        Panel flowNodeSimulationPanel = new Panel((UiContainer)this.flowNodeSimulationsCardPanel);
        flowNodeSimulationPanel.setLayout((Layout)new BorderLayout());
        Panel simulationsPanel = new Panel((UiContainer)flowNodeSimulationPanel);
        simulationsPanel.setLayout((Layout)new FlowLayout(0));
        simulationsPanel.add((UiComponent)Label.create((UiContainer)simulationsPanel, (Msg)DesignerMsg.SIMULATION_MODELS));
        this.modelSimulationCombo = UiFactory.createComboBox((UiContainer)simulationsPanel);
        simulationsPanel.add(this.modelSimulationCombo);
        Collection<ModelSimulation> modelSimulations = this.getModelSimulations(flowNode);
        this.modelSimulationCombo.addItems(modelSimulations);
        if (this.modelSimulationCombo.getItemCount() > 0) {
            this.modelSimulationCombo.setSelectedIndex(0);
        }
        this.modelSimulationCombo.addItemListener(this.getModelSimulationChangeListener());
        FlowNodePIEditorPanelBuilder piEditorPanelBuilder = BpmnTypePIPanelBuilderProvider.getInstance().get(flowNode.getBpmnType());
        this.flowNodeSimulationDetailPanel = piEditorPanelBuilder.buildSimulationPanel((UiContainer)flowNodeSimulationPanel, flowNode);
        if (this.modelSimulationCombo.getItemCount() > 0) {
            ModelSimulation modelSimulation = (ModelSimulation)this.modelSimulationCombo.getSelectedItem();
            this.flowNodeSimulationDetailPanel.changeSimulation(modelSimulation);
        }
        flowNodeSimulationPanel.add((UiComponent)simulationsPanel, (Object)"North");
        flowNodeSimulationPanel.add(this.flowNodeSimulationDetailPanel.getUiComponent(), (Object)"Center");
        return flowNodeSimulationPanel;
    }

    private Collection<ModelSimulation> getModelSimulations(PropertyModel model) {
        Process process = ((FlowNode)this.getElement(model)).getProcess();
        Sequence simulationsSequence = process.getProject().getSimulations().getModelSimulationsByProcess(process);
        return CollectionUtils.sort(simulationsSequence, new Comparator<ModelSimulation>(){

            @Override
            public int compare(ModelSimulation simulation1, ModelSimulation simulation2) {
                return simulation1.getName().compareTo(simulation2.getName());
            }
        });
    }

    private ItemListener getModelSimulationChangeListener() {
        if (this.simulationsComboListener == null) {
            this.simulationsComboListener = new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.changeSimulation((ModelSimulation)FlowNodeSimulationGUIComponent.this.modelSimulationCombo.getSelectedItem());
                        FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.populateValues();
                    }
                }
            };
        }
        return this.simulationsComboListener;
    }

    private Collection<ModelSimulation> getModelSimulations(FlowNode flowNode) {
        Process process = flowNode.getProcess();
        Sequence simulationsSequence = process.getProject().getSimulations().getModelSimulationsByProcess(process);
        return CollectionUtils.sort(simulationsSequence, new Comparator<ModelSimulation>(){

            @Override
            public int compare(ModelSimulation modelSimulation, ModelSimulation modelSimulation1) {
                return modelSimulation.getId().compareTo(modelSimulation1.getId());
            }
        });
    }

    private class FlowNodeSimulationCardPanel
    extends Panel
    implements EditableComponent<FlowNode> {
        public FlowNodeSimulationCardPanel(UiContainer parent) {
            super(parent);
        }

        public void setElement(FlowNode element) {
            FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.setElement(element);
        }

        public void validateEditor() throws ProjectException {
            FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.validateEditor();
        }

        public void applyChanges() {
            FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.applyChanges();
        }

        public void populateValues() {
            FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.populateValues();
        }

        public void loadValues() {
            FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.loadValues();
        }

        public UiComponent getUiComponent() {
            return this;
        }

        public FlowNode getElement() {
            return (FlowNode)FlowNodeSimulationGUIComponent.this.flowNodeSimulationDetailPanel.getElement();
        }

        public boolean isDirty() {
            return false;
        }
    }
}

