/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public abstract class BpmComponentFocusOwnerTracker
implements PropertyChangeListener,
VetoableChangeListener {
    private Component component;
    private KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    private boolean inside;
    private static final String PERMANENT_FOCUS_OWNER = "permanentFocusOwner";

    public BpmComponentFocusOwnerTracker(Component component) {
        this.component = component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean inside = this.isFocusInside(true);
        if (this.focusManager.getPermanentFocusOwner() != null) {
            if (inside) {
                if (!this.inside) {
                    this.focusGained();
                }
            } else if (this.inside) {
                this.focusLost();
            }
            this.inside = inside;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean inside;
        boolean bl = inside = evt.getOldValue() instanceof Component && this.isComponentInside((Component)evt.getOldValue());
        if (inside && this.inside && this.shouldVetoOnFocusLost()) {
            throw new PropertyVetoException("", evt);
        }
    }

    public void start() {
        this.focusManager.addPropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
        this.focusManager.addVetoableChangeListener(PERMANENT_FOCUS_OWNER, this);
        this.inside = this.isFocusInside(true);
    }

    public void stop() {
        this.focusManager.removePropertyChangeListener(PERMANENT_FOCUS_OWNER, this);
    }

    protected abstract void focusLost();

    protected abstract void focusGained();

    protected boolean shouldVetoOnFocusLost() {
        return false;
    }

    private boolean isFocusInside(boolean find) {
        if (!find) {
            return this.inside;
        }
        Component c = this.focusManager.getPermanentFocusOwner();
        return this.isComponentInside(c);
    }

    private boolean isComponentInside(Component c) {
        return c != null && SwingUtilities.isDescendingFrom(c, this.component) && !(c instanceof JRootPane);
    }
}

