/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.inspector.component;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.fusion.studio.inspector.component.FocusChangeListener;

public abstract class AbstractFocusChangeListener
implements FocusChangeListener {
    private EditableComponent component;
    private KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
    private boolean inside;

    public AbstractFocusChangeListener(EditableComponent component) {
        this.component = component;
        this.inside = this.isFocusInside(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean inside = this.isFocusInside(true);
        if (this.focusManager.getPermanentFocusOwner() != null) {
            if (inside) {
                if (!this.inside) {
                    this.focusGained();
                }
            } else if (this.inside) {
                this.focusLost();
            }
            this.inside = inside;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        boolean inside;
        boolean bl = inside = evt.getOldValue() instanceof Component && this.isComponentInside((Component)evt.getOldValue());
        if (inside && this.inside && this.shouldVetoOnFocusLost()) {
            throw new PropertyVetoException("", evt);
        }
    }

    protected abstract void focusLost();

    protected abstract void focusGained();

    protected EditableComponent getEditableComponent() {
        return this.component;
    }

    protected boolean shouldVetoOnFocusLost() {
        return false;
    }

    private boolean isFocusInside(boolean find) {
        if (!find) {
            return this.inside;
        }
        Component c = this.focusManager.getPermanentFocusOwner();
        return this.isComponentInside(c);
    }

    private boolean isComponentInside(Component c) {
        return c != null && SwingUtilities.isDescendingFrom(c, this.component.getUiComponent().asSwing()) && !(c instanceof JRootPane);
    }
}

