/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.bpm.designer.expression.ExpressionContainerImpl;
import oracle.bpm.draw.Color;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.InvalidExpression;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.LineBorder;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.javatools.editor.BasicEditorPane;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;

public class XmlLiteralExpressionBuilderPanel
extends ExpressionContainerImpl {
    private Panel containerPanel;
    private BasicEditorPane editor;

    private XmlLiteralExpressionBuilderPanel(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        super(parent, context);
        this.init(parent);
    }

    public static XmlLiteralExpressionBuilderPanel create(@NotNull UiContainer parent, @NotNull ExpressionContext context) {
        return new XmlLiteralExpressionBuilderPanel(parent, context);
    }

    public void setExpression(Expression expression) {
        assert (expression == null || expression instanceof InvalidExpression || expression.getMode().equals(ExpressionMode.XML_LITERAL)) : "Invalid expression mode for XML Literal Expression Builder";
        if (Any.equals(this.getExpression(), expression)) {
            return;
        }
        String expressionString = expression != null ? ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.getContext()) : null;
        this.editor.setText(expressionString);
        this.fireExpressionChanged();
    }

    public Expression getExpression() {
        Expression result = null;
        if (!Str.isEmpty(this.editor.getText())) {
            result = ExpressionHelper.createXmlLiteralExpression((String)this.editor.getText());
        }
        return result;
    }

    public UiComponent getUiComponent() {
        return this.containerPanel;
    }

    public boolean isExpressionValid() {
        boolean result = true;
        if (!Str.isEmpty(this.editor.getText())) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.editor.getText().getBytes());
            try {
                DocumentBuilderFactory dBF = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dBF.newDocumentBuilder();
                InputSource is = new InputSource(inputStream);
                builder.parse(is);
            }
            catch (Exception ex) {
                result = false;
            }
        }
        return result;
    }

    private void init(@NotNull UiContainer parent) {
        this.containerPanel = new Panel(parent);
        this.containerPanel.setLayout((Layout)new MigLayout("ins 10, gap 0, fill"));
        this.containerPanel.add((UiComponent)Label.create((UiContainer)this.containerPanel, (Msg)LibMsg.XML_LITERAL), (Object)"wrap");
        this.editor = new BasicEditorPane();
        this.editor.setLanguageSupport("dummy.xml");
        UiComponent uiEditor = UiComponent.get((Object)this.editor);
        ScrollPane scrollPane = new ScrollPane((UiContainer)this.containerPanel, ScrollPolicy.AS_NEEDED, ScrollPolicy.AS_NEEDED);
        scrollPane.add(uiEditor);
        scrollPane.setView(uiEditor);
        scrollPane.setBorder((Border)new LineBorder(Color.GRAY));
        this.containerPanel.add((UiComponent)scrollPane, (Object)"grow");
    }
}

