/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.JTextComponent;
import oracle.bpm.fusion.studio.expressionbuilder.BPMNFunctionNamespaceResolver;
import oracle.bpm.fusion.studio.expressionbuilder.DataDeclarationsPicker;
import oracle.bpm.fusion.studio.expressionbuilder.FusionExpressionBuilderPanel;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilders.ExpressionBuilderUsecases;
import oracle.tip.tools.ide.common.expressionbuilders.FunctionsExpressionBuilderPicker;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import org.jetbrains.annotations.NotNull;

public class XPathExpressionBuilderPanel
extends FusionExpressionBuilderPanel {
    private DataDeclarationsPicker dataDeclarationsPicker;
    private BPMNFunctionNamespaceResolver namespaceResolver;
    private static final long serialVersionUID = -7315814121122968428L;

    private XPathExpressionBuilderPanel(@NotNull JTextComponent editor, @NotNull DataDeclarationsPicker dataDeclarationsPicker, @NotNull FunctionsExpressionBuilderPicker functionsPicker, @NotNull BPMNFunctionNamespaceResolver namespaceResolver, @NotNull ExpressionContext context) {
        super(editor, new ExpressionBuilderPicker[]{dataDeclarationsPicker, functionsPicker}, context);
        this.dataDeclarationsPicker = dataDeclarationsPicker;
        this.namespaceResolver = namespaceResolver;
    }

    public static XPathExpressionBuilderPanel create(@NotNull ExpressionContext context, Expression expression) {
        XPathEditorPane editor = ExpressionBuilderUsecases.createXPathEditor((int)5);
        BPMNFunctionNamespaceResolver namespaceResolver = new BPMNFunctionNamespaceResolver();
        if (expression != null) {
            Map<String, URI> map = expression.getNamespaces();
            for (String id : map.keySet()) {
                namespaceResolver.addNSEntry(id, map.get(id).toString());
            }
        }
        DataDeclarationsPicker dataDeclarationsPicker = new DataDeclarationsPicker(context, ExpressionMode.XPATH);
        FunctionsExpressionBuilderPicker functionsPicker = ExpressionBuilderUsecases.createFunctionsExpressionBuilderPicker((NamespaceResolver)namespaceResolver, (int)5);
        functionsPicker.load();
        dataDeclarationsPicker.setUsedNamespaces(namespaceResolver.getNamespacesMap());
        if (expression != null) {
            String expressionText = expression.getExpressionValue();
            editor.setText(expressionText);
        }
        return new XPathExpressionBuilderPanel((JTextComponent)editor, dataDeclarationsPicker, functionsPicker, namespaceResolver, context);
    }

    public Expression getExpression() {
        String expressionText = this.getExpressionText();
        if (Str.isEmpty(expressionText)) {
            return null;
        }
        XPathExpression expression = new XPathExpression(expressionText, this.getAllUsedNamespaces());
        return ExpressionHelper.getPurgedExpression((XPathExpression)expression, (ExpressionContext)this.getContext());
    }

    public void setExpression(Expression expression) {
    }

    public String getExpressionText() {
        String exp = super.getExpressionText();
        int searchStart = 0;
        while (true) {
            int leftBracketIndex = exp.indexOf("{", searchStart);
            int rightBracketIndex = exp.indexOf("}", leftBracketIndex + 1);
            if (leftBracketIndex < 0 || rightBracketIndex <= leftBracketIndex) break;
            String namespace = exp.substring(leftBracketIndex + 1, rightBracketIndex);
            if (namespace.trim().length() > 1) {
                String prefix = this.namespaceResolver.addNSEntry(null, namespace);
                exp = exp.replace("{" + namespace + "}", prefix);
            }
            searchStart = leftBracketIndex + 1;
        }
        return exp;
    }

    @Override
    public boolean rebuildWhenExpressionChanges() {
        return true;
    }

    public boolean isExpressionValid() {
        return true;
    }

    private Map<String, URI> getAllUsedNamespaces() {
        HashMap<String, URI> result = new HashMap<String, URI>();
        Map<String, URI> editorNamespaces = this.namespaceResolver.getNamespacesMap();
        Map<String, URI> draggedNamespaces = this.dataDeclarationsPicker.getUsedNamespaces();
        result.putAll(editorNamespaces);
        result.putAll(draggedNamespaces);
        return result;
    }
}

