/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.type.TypeRenderer;
import oracle.bpm.compiler.xpath.StaticMethodsHelper;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Font;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListListModel;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPickerListener;
import oracle.tip.tools.ide.common.expressionbuilder.PickerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SimpleFunctionsPicker
implements ExpressionBuilderPicker {
    private ComboBox<FunctionsGroup> functionGroupsComboBox;
    private oracle.bpm.ui.List<Function> functionsList;
    private List<ExpressionBuilderPickerListener> listeners = new ArrayList<ExpressionBuilderPickerListener>();
    private Panel panel;

    SimpleFunctionsPicker() {
        this.init();
    }

    public String getTitle() {
        return DesignerMsg.FUNCTIONS.getString();
    }

    public void load() {
        this.loadFunctionGroups();
    }

    public JComponent getComponent() {
        return this.panel.asSwing();
    }

    public void addExpressionBuilderPickerListener(ExpressionBuilderPickerListener expressionBuilderPickerListener) {
        this.listeners.add(expressionBuilderPickerListener);
    }

    public void removeExpressionBuilderPickerListener(ExpressionBuilderPickerListener expressionBuilderPickerListener) {
        this.listeners.remove(expressionBuilderPickerListener);
    }

    private void init() {
        this.panel = new Panel(null);
        this.panel.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        this.functionGroupsComboBox = this.createFunctionGroupsComboBox((UiContainer)this.panel);
        this.panel.add(this.functionGroupsComboBox, (Object)"gapy 5, gapright 10, growx, wrap");
        this.functionsList = this.createFunctionsList((UiContainer)this.panel);
        this.panel.add(this.functionsList, (Object)"gapy 2, gapright 10, grow");
    }

    private ComboBox<FunctionsGroup> createFunctionGroupsComboBox(@NotNull UiContainer container) {
        ComboBox result = UiFactory.createComboBox((UiContainer)container);
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.isStateSelected()) {
                    SimpleFunctionsPicker.this.reloadFunctionsList();
                }
            }
        });
        result.setLabelProvider((LabelProvider)new LabelProvider.Default<FunctionsGroup>(){

            public String getText(FunctionsGroup element) {
                return element.getText();
            }
        });
        return result;
    }

    private oracle.bpm.ui.List<Function> createFunctionsList(@NotNull UiContainer container) {
        final oracle.bpm.ui.List result = new oracle.bpm.ui.List(container, ListSelectionMode.SINGLE_SELECTION);
        result.setLabelProvider((LabelProvider)new LabelProvider<Function>(){

            public Image getIcon(Function element) {
                return Image.create((Msg)DesignerMsg.FUNCTION);
            }

            public String getText(Function element) {
                return element.getText();
            }
        });
        result.setFontProvider(new FontProvider(){

            public Font getFont(Object element) {
                return result.getFont().bold();
            }
        });
        result.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SimpleFunctionsPicker.this.firePickerEvent(0);
            }
        });
        result.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SimpleFunctionsPicker.this.firePickerEvent(0);
            }

            public void mouseDoubleClicked(MouseEvent e) {
                SimpleFunctionsPicker.this.firePickerEvent(1);
            }
        });
        new DragSourceHandler((UiComponent)result, DndAction.COPY_OR_MOVE){

            public Object getObject(Transfer type) {
                return SimpleFunctionsPicker.this.getSelectedTemplate();
            }

            public Transfer[] getTransfers() {
                return new Transfer[]{TextTransfer.getInstance()};
            }
        };
        return result;
    }

    private void loadFunctionGroups() {
        for (TypeDescription type : StaticMethodsHelper.getStaticTypes()) {
            ObjectTypeDescription otd = type.asObject();
            OTDGroup otdGroup = new OTDGroup(otd);
            this.functionGroupsComboBox.addItem((Object)otdGroup);
        }
        this.functionGroupsComboBox.addItem((Object)this.createArithmeticOperatorsGroup());
        this.functionGroupsComboBox.addItem((Object)this.createLogicalOperatorsGroup());
        if (this.functionGroupsComboBox.getItemCount() > 0) {
            this.functionGroupsComboBox.setSelectedIndex(0);
        }
    }

    private void reloadFunctionsList() {
        List<Object> functions = new ArrayList();
        FunctionsGroup group = (FunctionsGroup)this.functionGroupsComboBox.getSelectedItem();
        if (group != null) {
            functions = group.getFunctions();
        }
        ListListModel model = new ListListModel(functions);
        this.functionsList.setModel((ListModel)model);
        if (!functions.isEmpty()) {
            this.functionsList.setSelectedIndex(0);
        }
    }

    private String getSelectedPreview() {
        Function selectedFunction = (Function)this.functionsList.getSelectedValue();
        if (selectedFunction == null) {
            return "";
        }
        return selectedFunction.getPreview();
    }

    private String getSelectedTemplate() {
        Function selectedFunction = (Function)this.functionsList.getSelectedValue();
        if (selectedFunction == null) {
            return "";
        }
        return selectedFunction.getTemplate();
    }

    private String getSelectedDocumentation() {
        Function selectedFunction = (Function)this.functionsList.getSelectedValue();
        if (selectedFunction == null) {
            return "";
        }
        return selectedFunction.getDescription();
    }

    private void firePickerEvent(int eventId) {
        StringBuilder sb = new StringBuilder();
        sb.append("<i>");
        sb.append(Str.convertToHTMLString(this.getSelectedPreview()));
        sb.append("</i><p>");
        sb.append(Str.convertToHTMLString(this.getSelectedDocumentation()));
        PickerEvent event = new PickerEvent((Object)this, eventId);
        event.setDescription(sb.toString());
        event.setPreview(this.getSelectedTemplate());
        for (ExpressionBuilderPickerListener listener : this.listeners) {
            listener.pickerEventOccurred(event);
        }
    }

    private OperatorsGroup createArithmeticOperatorsGroup() {
        return new OperatorsGroup(DesignerMsg.ARITHMETIC_OPERATORS.getString()){

            @Override
            protected List<Function> createFunctionsList() {
                ArrayList<Function> result = new ArrayList<Function>();
                result.add(new Operator(DesignerMsg.ADDITION_OPERATOR.getString(), "+", DesignerMsg.ADDITION_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.SUBSTRACTION_OPERATOR.getString(), "-", DesignerMsg.SUBSTRACTION_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.MULTIPLICATION_OPERATOR.getString(), "*", DesignerMsg.MULTIPLICATION_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.DIVISION_OPERATOR.getString(), "/", DesignerMsg.DIVISION_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.REMAINDER_OPERATOR.getString(), "%", DesignerMsg.REMAINDER_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.PRECEDENCE_OPERATOR.getString(), "( )", DesignerMsg.PRECEDENCE_OPERATOR.getString()));
                return result;
            }
        };
    }

    private OperatorsGroup createLogicalOperatorsGroup() {
        return new OperatorsGroup(DesignerMsg.LOGICAL_OPERATORS.getString()){

            @Override
            protected List<Function> createFunctionsList() {
                ArrayList<Function> result = new ArrayList<Function>();
                result.add(new Operator(DesignerMsg.EQUALS_OPERATOR.getString(), "==", DesignerMsg.EQUALS_OPERATOR.getString()));
                result.add(new Operator(DesignerMsg.NOT_EQUALS_OPERATOR.getString(), "!=", DesignerMsg.NOT_EQUALS_OPERATOR.getString()));
                result.add(new Operator(DesignerMsg.GREATER_THAN_OPERATOR.getString(), ">", DesignerMsg.GREATER_THAN_OPERATOR.getString()));
                result.add(new Operator(DesignerMsg.GREATER_THAN_OR_EQUAL_TO_OPERATOR.getString(), ">=", DesignerMsg.GREATER_THAN_OR_EQUAL_TO_OPERATOR.getString()));
                result.add(new Operator(DesignerMsg.LESS_THAN_OPERATOR.getString(), "<", DesignerMsg.LESS_THAN_OPERATOR.getString()));
                result.add(new Operator(DesignerMsg.LESS_THAN_OR_EQUAL_TO_OPERATOR.getString(), "<=", DesignerMsg.LESS_THAN_OR_EQUAL_TO_OPERATOR.getString()));
                result.add(new Operator(DesignerMsg.AND_OPERATOR.getString(), "and", DesignerMsg.AND_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.OR_OPERATOR.getString(), "or", DesignerMsg.OR_OPERATOR_DESCRIPTION.getString()));
                result.add(new Operator(DesignerMsg.NOT_OPERATOR.getString(), "not", DesignerMsg.NOT_OPERATOR_DESCRIPTION.getString()));
                return result;
            }
        };
    }

    private static class OTDGroup
    implements FunctionsGroup {
        private List<Function> functions;
        private ObjectTypeDescription otd;

        public OTDGroup(@NotNull ObjectTypeDescription otd) {
            this.otd = otd;
        }

        @Override
        public String getText() {
            if (this.otd.isString()) {
                return FusionStudioMsg.STRING_TYPE.toString();
            }
            if (this.otd.isNumber()) {
                return FusionStudioMsg.NUMERIC_TYPE.toString();
            }
            if (this.otd.isTime()) {
                return FusionStudioMsg.TIME_TYPE.toString();
            }
            return this.otd.getName();
        }

        @Override
        public List<Function> getFunctions() {
            if (this.functions == null) {
                this.functions = new ArrayList<Function>();
                for (MethodTypeDescription mtd : this.otd.getMethods()) {
                    do {
                        MTDFunction function = new MTDFunction(mtd);
                        this.functions.add(function);
                    } while ((mtd = mtd.getNextMethod()) != null);
                }
            }
            return this.functions;
        }
    }

    private static class Operator
    implements Function {
        private String description;
        private String text;
        private String value;

        private Operator(@NotNull String text, @NotNull String value, @Nullable String description) {
            this.text = text;
            this.value = value;
            this.description = description;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getTemplate() {
            return this.value;
        }

        @Override
        public String getPreview() {
            return this.getTemplate();
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private static class MTDFunction
    implements Function {
        private MethodTypeDescription mtd;
        private static TypeRenderer typeRenderer;

        private MTDFunction(@NotNull MethodTypeDescription mtd) {
            this.mtd = mtd;
        }

        @Override
        public String getText() {
            return this.mtd.getName();
        }

        @Override
        public String getTemplate() {
            return StaticMethodsHelper.getTemplate((MethodTypeDescription)this.mtd);
        }

        @Override
        public String getPreview() {
            return MTDFunction.getTypeRenderer().render((TypeRef)this.mtd);
        }

        @Override
        public String getDescription() {
            String desc = this.mtd.getDescription();
            return desc == null ? "" : desc;
        }

        @NotNull
        private static TypeRenderer getTypeRenderer() {
            TypeRenderer result = typeRenderer;
            if (result == null) {
                LanguageSpec spec;
                try {
                    spec = LanguageSpec.getLanguageSpec((String)"Fuego");
                }
                catch (InvalidLanguageException e) {
                    throw new IllegalArgumentException(e);
                }
                typeRenderer = result = spec.getTypeRenderer();
            }
            return result;
        }
    }

    private static abstract class OperatorsGroup
    implements FunctionsGroup {
        private List<Function> functions;
        private String text;

        public OperatorsGroup(@NotNull String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public List<Function> getFunctions() {
            if (this.functions == null) {
                this.functions = this.createFunctionsList();
            }
            return this.functions;
        }

        protected abstract List<Function> createFunctionsList();
    }

    private static interface FunctionsGroup {
        public String getText();

        public List<Function> getFunctions();
    }

    private static interface Function {
        public String getText();

        public String getTemplate();

        public String getPreview();

        public String getDescription();
    }
}

