/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.bpm.fusion.studio.codeeditor.FusionCodeEditor;
import oracle.bpm.fusion.studio.expressionbuilder.DataDeclarationsPicker;
import oracle.bpm.fusion.studio.expressionbuilder.FusionExpressionBuilderPanel;
import oracle.bpm.fusion.studio.expressionbuilder.SimpleFunctionsPicker;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import org.jetbrains.annotations.NotNull;

public class SimpleExpressionBuilderPanel
extends FusionExpressionBuilderPanel {
    private FusionCodeEditor editor;
    private static final long serialVersionUID = -7315814121122968428L;

    private SimpleExpressionBuilderPanel(@NotNull ExpressionContext context, @NotNull FusionCodeEditor editor, @NotNull ExpressionBuilderPicker[] pickers) {
        super((JTextComponent)editor.getTextEditor(), pickers, context);
        this.editor = editor;
    }

    public static SimpleExpressionBuilderPanel create(@NotNull ExpressionContext context, Expression expression) {
        FusionCodeEditor editor = new FusionCodeEditor(context, true);
        ExpressionBuilderPicker[] pickers = new ExpressionBuilderPicker[]{new DataDeclarationsPicker(context, ExpressionMode.SIMPLE), new SimpleFunctionsPicker()};
        SimpleExpressionBuilderPanel result = new SimpleExpressionBuilderPanel(context, editor, pickers);
        result.setExpression(expression);
        return result;
    }

    public Expression getExpression() {
        String expressionString = this.getExpressionString();
        if (Str.isEmpty(expressionString)) {
            return null;
        }
        return ExpressionHelper.createSimpleExpression((String)expressionString, (ExpressionContext)this.getContext());
    }

    public void setExpression(Expression expression) {
        String text;
        String string = text = expression != null ? ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.getContext()) : null;
        if (!Any.equals(text, this.getExpressionString())) {
            this.editor.setText(text);
            this.fireExpressionChanged();
        }
    }

    public boolean isExpressionValid() {
        return ExpressionHelper.isExpressionValid((Expression)this.getExpression(), (ExpressionContext)this.getContext());
    }

    private String getExpressionString() {
        try {
            return new String(this.editor.getEditorDocument().getChars());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }
}

