/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTree;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.PredefinedDeclaration;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.TextTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.tree.TreeNode;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPicker;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilderPickerListener;
import oracle.tip.tools.ide.common.expressionbuilder.PickerEvent;
import org.jetbrains.annotations.NotNull;

class DataDeclarationsPicker
implements ExpressionBuilderPicker {
    private ExpressionContext context;
    private ArrayList<ExpressionBuilderPickerListener> listeners = new ArrayList();
    private ExpressionMode mode;
    private JScrollPane scrollPane;
    private DataDeclarationTree tree;
    private Map<String, URI> usedNamespaces = new HashMap<String, URI>();

    public DataDeclarationsPicker(@NotNull ExpressionContext context, @NotNull ExpressionMode mode) {
        this.mode = mode;
        this.context = context.copy();
        this.context.setIgnoreReadOnly(true);
        this.context.setResultType(null);
        this.tree = new DataDeclarationTree((UiContainer)Ui.getRoot(), context.getDeclarationsContainer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DataDeclarationsPicker.this.fireSelectionChange();
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DataDeclarationsPicker.this.fireSelectionChange();
            }
        });
        this.scrollPane = new JScrollPane(this.tree.asSwing());
        new DragSourceHandler((UiComponent)this.tree, DndAction.COPY_OR_MOVE){

            public Transfer[] getTransfers() {
                DataDeclarationTreeNode dataDeclarationTreeNode;
                Transfer[] result = Transfer.NONE;
                TreeNode node = DataDeclarationsPicker.this.tree.getSelectedTreeNode();
                if (node instanceof DataDeclarationTreeNode && !(dataDeclarationTreeNode = (DataDeclarationTreeNode)node).isShadowed()) {
                    result = new Transfer[]{TextTransfer.getInstance()};
                }
                return result;
            }

            public Object getObject(Transfer transfer) {
                TreeNode node;
                String result = null;
                if (TextTransfer.getInstance() == transfer && (node = DataDeclarationsPicker.this.tree.getSelectedTreeNode()) instanceof DataDeclarationTreeNode) {
                    DataDeclarationTreeNode dataDeclarationTreeNode = (DataDeclarationTreeNode)node;
                    result = DataDeclarationsPicker.this.getDeclarationExpressionText(dataDeclarationTreeNode);
                }
                return result;
            }
        };
    }

    public String getTitle() {
        return DesignerMsg.VARIABLES.getString();
    }

    public void load() {
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void addExpressionBuilderPickerListener(ExpressionBuilderPickerListener expressionBuilderPickerListener) {
        this.listeners.add(expressionBuilderPickerListener);
    }

    public void removeExpressionBuilderPickerListener(ExpressionBuilderPickerListener expressionBuilderPickerListener) {
        this.listeners.remove(expressionBuilderPickerListener);
    }

    public void setUsedNamespaces(@NotNull Map<String, URI> usedNamespaces) {
        this.usedNamespaces = usedNamespaces;
    }

    public Map<String, URI> getUsedNamespaces() {
        return this.usedNamespaces;
    }

    private void fireSelectionChange() {
        DataDeclarationTreeNode dataDeclarationTreeNode;
        String preview = null;
        String description = null;
        TreeNode selectedTreeNode = this.tree.getSelectedTreeNode();
        if (selectedTreeNode instanceof DataDeclarationTreeNode && !(dataDeclarationTreeNode = (DataDeclarationTreeNode)selectedTreeNode).isShadowed()) {
            preview = this.getDeclarationExpressionText(dataDeclarationTreeNode);
            description = this.getDeclarationDescription(dataDeclarationTreeNode);
        }
        PickerEvent event = new PickerEvent((Object)this, 0);
        event.setDescription(description);
        event.setPreview(preview);
        for (ExpressionBuilderPickerListener listener : this.listeners) {
            listener.pickerEventOccurred(event);
        }
    }

    private String getDeclarationDescription(@NotNull DataDeclarationTreeNode dataDeclarationTreeNode) {
        DataDeclaration selectedDeclaration = dataDeclarationTreeNode.getDataDeclaration();
        return selectedDeclaration.isPredefinedDeclaration() ? ((PredefinedDeclaration)selectedDeclaration).getDescription().getString() : selectedDeclaration.getDeclarationType().getString();
    }

    private String getDeclarationExpressionText(@NotNull DataDeclarationTreeNode dataDeclarationTreeNode) {
        String result = null;
        Sequence selectedDeclarationPath = dataDeclarationTreeNode.getDeclarationsPath();
        this.context.setUsedNameSpaces(this.usedNamespaces);
        Expression expression = ExpressionHelper.createExpressionFromParts((ExpressionMode)this.mode, (Sequence)selectedDeclarationPath, (ExpressionContext)this.context);
        this.appendUsedNamespaces(expression.getNamespaces());
        if (ExpressionHelper.isExpressionValid((Expression)expression, (ExpressionContext)this.context)) {
            result = ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.context);
        }
        return result;
    }

    private void appendUsedNamespaces(@NotNull Map<String, URI> newNamespaces) {
        for (String id : newNamespaces.keySet()) {
            if (this.usedNamespaces.containsKey(id)) continue;
            this.usedNamespaces.put(id, newNamespaces.get(id));
        }
    }
}

