/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.expressionbuilder;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.tip.tools.ide.common.utils.NamespaceConflictException;
import oracle.tip.tools.ide.common.utils.NamespaceResolver;

public class BPMNFunctionNamespaceResolver
implements NamespaceResolver {
    private Map<String, String> map = new HashMap<String, String>();
    private static String BPMN_FIXED_PREFIX = "bpmn";
    private static String BPMN_FIXED_URI = "http://www.omg.org/bpmn20";

    public BPMNFunctionNamespaceResolver() {
        this.map.put(BPMN_FIXED_PREFIX, BPMN_FIXED_URI);
    }

    public String resolveNamespaceURI(String uri) {
        String result = null;
        if (uri != null) {
            for (Map.Entry<String, String> namespace : this.map.entrySet()) {
                if (!uri.equals(namespace.getValue())) continue;
                result = namespace.getKey();
                break;
            }
        }
        return result;
    }

    public void addNSEntries(String[][] namespaces) throws NamespaceConflictException {
        for (String[] namespace : namespaces) {
            String uri;
            String prefix;
            if (namespace.length == 2) {
                prefix = namespace[0];
                uri = namespace[1];
                if (this.map.containsKey(prefix)) {
                    throw new NamespaceConflictException("Duplicated prefix: " + prefix, 1);
                }
            } else {
                throw new NamespaceConflictException("Invalid Namespace", 3);
            }
            this.addNSEntry(prefix, uri);
        }
    }

    public String[][] getAllNSEntries() {
        String[][] result = new String[this.map.size()][2];
        int i = 0;
        for (Map.Entry<String, String> namespace : this.map.entrySet()) {
            result[i][0] = namespace.getKey();
            result[i][1] = namespace.getValue();
            ++i;
        }
        return result;
    }

    public String addNSEntry(String prefix, String uri) {
        if (prefix != null && !prefix.equals(BPMN_FIXED_PREFIX)) {
            this.map.put(prefix, uri);
        }
        return prefix;
    }

    public String removeNSEntry(String uri) {
        String result = null;
        if (uri != null) {
            ArrayList<String> prefixesToRemove = new ArrayList<String>();
            for (Map.Entry<String, String> namespace : this.map.entrySet()) {
                if (!uri.equals(namespace.getValue())) continue;
                prefixesToRemove.add(namespace.getKey());
            }
            for (String prefixToRemove : prefixesToRemove) {
                this.map.remove(prefixToRemove);
            }
            if (prefixesToRemove.size() > 0) {
                result = (String)prefixesToRemove.iterator().next();
            }
        }
        return result;
    }

    public void removeAllNSEntries() {
        this.map.clear();
    }

    public String resolveNamespacePrefix(String prefix) {
        return this.map.get(prefix);
    }

    public Map<String, URI> getNamespacesMap() {
        HashMap<String, URI> result = new HashMap<String, URI>();
        for (String[] entry : this.getAllNSEntries()) {
            if (entry.length != 2) continue;
            result.put(entry[0], URI.create(entry[1]));
        }
        return result;
    }
}

