/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.editor;

import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.CalendarRulesPanel;
import oracle.bpm.designer.organization.HolidayRulesPanel;
import oracle.bpm.designer.organization.OrganizationalUnitsPanel;
import oracle.bpm.designer.organization.RolesPanel;
import oracle.bpm.draw.Color;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;

@Editor(objectClass=Organization.class)
public class OrganizationEditor
extends AbstractEditor<Organization> {
    private CalendarRulesPanel calendarRulesPanel;
    private CheckBox existingObjectCheckBox;
    private HolidayRulesPanel holidayRulesPanel;
    private TabbedPane organizationTabbedPane;
    private OrganizationalUnitsPanel ousPanel;
    private RolesPanel rolesPanel;
    private UiContainer uiParent;

    public OrganizationEditor(UiContainer parent, Organization organization) {
        super(parent, (ProjectObject)organization, Organization.class);
        this.addVisibilityListener(new VisibilityListener(){

            public void onDispose() {
                System.out.print("");
            }
        });
    }

    public Image getIcon() {
        return Image.create((Msg)this.getEditorType().getMsg());
    }

    public EditorType getEditorType() {
        return EditorType.ORGANIZATION;
    }

    public void openPart(Object part) {
    }

    public String getHelpId() {
        return this.organizationTabbedPane.getHelpId();
    }

    protected UiContainer createMainPanel() {
        return this;
    }

    protected void buildUI(UiContainer parent) {
        this.uiParent = parent;
        parent.setLayout((Layout)new BorderLayout());
        this.organizationTabbedPane = new TabbedPane(parent, 2){

            public void addTab(Msg msg, Image icon, UiComponent component, String tooltip) {
                ScrollPane scroll = new ScrollPane(component.getParent());
                component.setParent((UiContainer)scroll);
                scroll.setView(component);
                super.addTab(msg, icon, (UiComponent)scroll, tooltip);
            }

            public String getHelpId() {
                return OrganizationEditor.this.getDefaultHelpId() + "." + this.getTabHelpId();
            }
        };
        JTabbedPane tabbedPane = (JTabbedPane)this.organizationTabbedPane.asSwing();
        tabbedPane.setUI((TabbedPaneUI)new FlatTabbedPaneUI());
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.organizationTabbedPane.putClientProperty("inherit.background.color", (Object)Color.WHITE);
        this.rolesPanel = new RolesPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject());
        this.organizationTabbedPane.addTab(DesignerMsg.ROLES, (UiComponent)this.rolesPanel);
        this.ousPanel = new OrganizationalUnitsPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject());
        this.organizationTabbedPane.addTab(DesignerMsg.ORGANIZATIONAL_CHART, (UiComponent)this.ousPanel);
        this.holidayRulesPanel = new HolidayRulesPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject());
        this.organizationTabbedPane.addTab(DesignerMsg.HOLIDAYS, (UiComponent)this.holidayRulesPanel);
        this.calendarRulesPanel = new CalendarRulesPanel((UiContainer)this.organizationTabbedPane, (Organization)this.getProjectObject());
        this.organizationTabbedPane.addTab(DesignerMsg.CALENDARS_ICON, (UiComponent)this.calendarRulesPanel);
        parent.add((UiComponent)this.organizationTabbedPane, (Object)"Center");
        Panel footerPanel = new Panel(parent);
        footerPanel.setLayout((Layout)new MigLayout("ins 5"));
        this.existingObjectCheckBox = CheckBox.create((UiContainer)footerPanel, (Msg)FusionStudioMsg.UPDATE_EXISTING_OBJECT);
        footerPanel.add((UiComponent)this.existingObjectCheckBox, (Object)"align right");
        parent.add((UiComponent)footerPanel, (Object)"South");
    }

    protected void editorToObject() {
        ((Organization)this.getProjectObject()).setUpdateExistingObject(this.existingObjectCheckBox.isSelected());
    }

    protected void objectToEditor() {
        if (this.objectReplaced) {
            this.rolesPanel.dispose();
            this.ousPanel.dispose();
            this.holidayRulesPanel.dispose();
            this.calendarRulesPanel.dispose();
            this.uiParent.removeAll();
            this.buildUI(this.uiParent);
            this.uiParent.revalidate();
        }
        this.existingObjectCheckBox.setSelected(((Organization)this.getProjectObject()).isUpdateExistingObjects());
    }

    protected void onDispose() {
        this.calendarRulesPanel.setVisible(false);
        this.rolesPanel.setVisible(false);
        this.ousPanel.setVisible(false);
        this.holidayRulesPanel.setVisible(false);
    }
}

