/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.XSLTransformationService;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.renderers.DataDeclarationRenderer;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.ListPicker;
import oracle.bpm.ui.ListPickerListener;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;
import oracle.tip.tools.ide.assign.panel.CanvasEditorInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformationCanvasEditor
implements CanvasEditorInterface {
    private DataAssociationSet dataAssociationSet;

    public TransformationCanvasEditor(@NotNull DataAssociationSet dataAssociationSet) {
        this.dataAssociationSet = dataAssociationSet;
    }

    public Object createCanvasObject(Object toModelNode) {
        DataTransformation result = null;
        DataDeclarationTreeNode toNode = (DataDeclarationTreeNode)toModelNode;
        DataDeclaration targetDeclaration = null;
        if (toNode != null) {
            targetDeclaration = toNode.getDataDeclaration();
        }
        TransformationCanvasEditorDialog dialog = new TransformationCanvasEditorDialog(Ui.getRoot(), null, targetDeclaration);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            result = dialog.getDataTransformation();
        }
        return result;
    }

    public Object modifyCanvasObject(Object canvasObject, Object toModelNode) {
        DataTransformation result = null;
        DataTransformation dataTransformation = (DataTransformation)canvasObject;
        TransformationCanvasEditorDialog dialog = new TransformationCanvasEditorDialog(Ui.getRoot(), dataTransformation, null);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            result = dialog.getDataTransformation();
        }
        return result;
    }

    public class TransformationCanvasEditorDialog
    extends OkCancelDialog {
        private RadioButton createNewRadio;
        private DataTransformation dataTransformation;
        private ButtonGroup<RadioButton> radioGroup;
        private ListPicker<DataDeclaration> sourcesList;
        private ComboBox<DataDeclaration> targetComboBox;
        private ComboBox<XSLTransformation> tranformationComboBox;
        private TextField transformationTextField;
        private Predicate<DataDeclaration> VALID_DECLARATION_PREDICATE;

        public TransformationCanvasEditorDialog(@Nullable UiWindow parent, @Nullable DataTransformation dataTransformation, DataDeclaration target) {
            super(parent);
            this.radioGroup = new ButtonGroup();
            this.VALID_DECLARATION_PREDICATE = new Predicate<DataDeclaration>(){

                @Override
                public boolean check(@Nullable DataDeclaration value) {
                    return value != null && TransformationCanvasEditorDialog.this.isValidDeclaration(value);
                }
            };
            this.dataTransformation = dataTransformation;
            this.init(target);
        }

        public void ok() {
            Msg errorMessage = this.validateInput();
            if (errorMessage != null) {
                MessageDialog.showError((Msg)errorMessage);
                return;
            }
            if (this.isCreatingNewTransformation()) {
                String name = this.transformationTextField.getText();
                this.getXSLTransformationService().createXSLTransformation(this.getProject(), name, CollectionUtils.asSequence(this.sourcesList.getSelectedItems()), (DataDeclaration)this.targetComboBox.getSelectedItem());
            }
            if (this.isNew()) {
                this.dataTransformation = this.createTransformation();
            } else {
                this.updateTransformation(this.dataTransformation);
            }
            this.close();
        }

        public DataTransformation getDataTransformation() {
            return this.dataTransformation;
        }

        private XSLTransformationService getXSLTransformationService() {
            return AbstractStudioWorkbench.getInstance().getXSLTransformationService();
        }

        private boolean isValidDeclaration(@NotNull DataDeclaration declaration) {
            return this.getXSLTransformationService().isValidDeclaration(declaration);
        }

        private boolean isNew() {
            return this.dataTransformation == null;
        }

        private boolean isCreatingNewTransformation() {
            return this.createNewRadio.isSelected();
        }

        private Msg validateInput() {
            if (this.sourcesList.getSelectedItems().isEmpty()) {
                return DesignerMsg.DATA_TRANSFORMATION_SOURCES_NOT_EMPTY;
            }
            for (DataDeclaration source : this.sourcesList.getSelectedItems()) {
                if (this.isValidDeclaration(source)) continue;
                return DesignerMsg.DATA_TRANSFORMATION_SOURCES_ELEMENT_SCHEMA;
            }
            DataDeclaration target = (DataDeclaration)this.targetComboBox.getSelectedItem();
            if (target == null) {
                return DesignerMsg.DATA_TRANSFORMATION_TARGET_NOT_NULL;
            }
            if (!this.isValidDeclaration(target)) {
                return DesignerMsg.DATA_TRANSFORMATION_TARGET_ELEMENT_SCHEMA;
            }
            if (this.isCreatingNewTransformation() && Str.isEmpty(this.transformationTextField.getText())) {
                return DesignerMsg.DATA_TRANSFORMATION_NAME_NOT_EMPTY;
            }
            if (!this.isCreatingNewTransformation()) {
                XSLTransformation xslTransformation = (XSLTransformation)this.tranformationComboBox.getSelectedItem();
                Sequence selectedSources = CollectionUtils.asSequence(this.sourcesList.getSelectedItems());
                DataDeclaration selectedTarget = (DataDeclaration)this.targetComboBox.getSelectedItem();
                if (!this.getXSLTransformationService().matchWithExistingXSLTransformation(xslTransformation, selectedSources, selectedTarget)) {
                    return DesignerMsg.DATA_TRANSFORMATION_XSL_MISMATCH;
                }
            }
            return null;
        }

        private Project getProject() {
            return TransformationCanvasEditor.this.dataAssociationSet.getProject();
        }

        private void updateTransformation(@NotNull DataTransformation transformation) {
            transformation.setSourceRefs(this.getSelectedSourceRefs());
            transformation.setTargetRef(this.getSelectedTargetRef());
            transformation.setTransformationName(this.getSelectedTransformationName());
        }

        private DataTransformation createTransformation() {
            return TransformationCanvasEditor.this.dataAssociationSet.createDataTransformation(this.getSelectedSourceRefs(), this.getSelectedTargetRef(), this.getSelectedTransformationName());
        }

        private Sequence<String> getSelectedSourceRefs() {
            ArrayList<String> result = new ArrayList<String>();
            for (DataDeclaration source : this.sourcesList.getSelectedItems()) {
                result.add(source.getName());
            }
            return CollectionUtils.asSequence(result);
        }

        private String getSelectedTargetRef() {
            return this.targetComboBox.getSelectedItem() != null ? ((DataDeclaration)this.targetComboBox.getSelectedItem()).getName() : null;
        }

        private String getSelectedTransformationName() {
            return this.isCreatingNewTransformation() ? this.transformationTextField.getText() : ((XSLTransformation)this.tranformationComboBox.getSelectedItem()).getId();
        }

        private void init(@Nullable DataDeclaration selectedTarget) {
            Panel mainPanel = Panel.createPanelWithBorder((UiContainer)this);
            mainPanel.setLayout((Layout)new MigLayout("fill"));
            DataDeclarationContainer sourcesContainer = TransformationCanvasEditor.this.dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
            DataDeclarationContainer targetsContainer = TransformationCanvasEditor.this.dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
            XSLTransformationsContainer xslTransformationsContainer = this.getProject().getResourceFilesContainer().getXSLTransformationsContainer();
            Panel sourcesPanel = new Panel((UiContainer)mainPanel, DesignerMsg.SOURCES);
            sourcesPanel.setLayout((Layout)new MigLayout("fill"));
            this.sourcesList = this.createSourcesList((UiContainer)sourcesPanel, sourcesContainer);
            sourcesPanel.add(this.sourcesList, (Object)"grow");
            mainPanel.add((UiComponent)sourcesPanel, (Object)"grow, wrap");
            Panel targetPanel = new Panel((UiContainer)mainPanel, DesignerMsg.TARGET);
            targetPanel.setLayout((Layout)new MigLayout("fill"));
            Label targetLabel = Label.create((UiContainer)targetPanel, (Msg)DesignerMsg.TARGET);
            this.targetComboBox = this.createTargetComboBox((UiContainer)mainPanel, targetsContainer);
            targetPanel.add((UiComponent)targetLabel);
            targetPanel.add(this.targetComboBox, (Object)"gapx 5, growx");
            mainPanel.add((UiComponent)targetPanel, (Object)"grow, wrap");
            Panel transformationPanel = new Panel((UiContainer)mainPanel, DesignerMsg.TRANSFORMATION);
            transformationPanel.setLayout((Layout)new MigLayout("fill"));
            this.createNewRadio = this.createCreateNewRadio((UiContainer)transformationPanel);
            this.transformationTextField = this.createTransformationTextField((UiContainer)transformationPanel);
            RadioButton useExistentRadio = this.createUseExistingRadio((UiContainer)transformationPanel);
            this.tranformationComboBox = this.createTransformationComboBox((UiContainer)transformationPanel, xslTransformationsContainer);
            this.radioGroup.add((AbstractButton)this.createNewRadio);
            this.radioGroup.add((AbstractButton)useExistentRadio);
            transformationPanel.add((UiComponent)this.createNewRadio);
            transformationPanel.add((UiComponent)this.transformationTextField, (Object)"wrap, growx");
            transformationPanel.add((UiComponent)useExistentRadio);
            transformationPanel.add(this.tranformationComboBox, (Object)"wrap, growx");
            mainPanel.add((UiComponent)transformationPanel, (Object)"growx");
            this.getContentPane().add((UiComponent)mainPanel);
            if (this.dataTransformation != null) {
                ArrayList<DataDeclaration> selectedSources = new ArrayList<DataDeclaration>();
                for (String sourceName : this.dataTransformation.getSourceRefs()) {
                    DataDeclaration source = sourcesContainer.findDeclaration(sourceName);
                    if (source == null) continue;
                    selectedSources.add(source);
                }
                this.sourcesList.setSelectedItems(selectedSources);
                DataDeclaration target = targetsContainer.findDeclaration(this.dataTransformation.getTargetRef());
                this.targetComboBox.setSelectedItem((Object)target);
                useExistentRadio.setSelected(true);
                XSLTransformation selectedTransformation = (XSLTransformation)xslTransformationsContainer.findChild(XSLTransformation.class, this.dataTransformation.getTransformationName());
                this.tranformationComboBox.setSelectedItem((Object)selectedTransformation);
            } else {
                this.createNewRadio.setSelected(true);
                if (selectedTarget != null) {
                    this.targetComboBox.setSelectedItem((Object)selectedTarget);
                }
            }
            String title = this.isNew() ? ProjectUiMsg.CREATE((Msg)DesignerMsg.TRANSFORMATION).getString() : ProjectUiMsg.EDIT((Msg)DesignerMsg.TRANSFORMATION).getString();
            this.setTitle(title);
            this.setSize(500, 400);
            this.setLocationRelativeTo((UiComponent)this.getParent());
        }

        private ListPicker<DataDeclaration> createSourcesList(@NotNull UiContainer container, @NotNull DataDeclarationContainer sourcesContainer) {
            DataDeclaration[] validSources = sourcesContainer.getDeclarations().select(this.VALID_DECLARATION_PREDICATE).toArray(new DataDeclaration[0]);
            ListPicker result = new ListPicker(container, DesignerMsg.SOURCES);
            result.setItems(Arrays.asList(validSources));
            result.addListener(new ListPickerListener(){

                public void selectedItemsChanged() {
                    TransformationCanvasEditorDialog.this.resetDefaultXSLFileName();
                }
            });
            result.setLabelProvider(this.createDataDeclarationLabelProvider());
            return result;
        }

        private ComboBox<DataDeclaration> createTargetComboBox(@NotNull UiContainer container, @NotNull DataDeclarationContainer targetsContainer) {
            Object[] validTargets = targetsContainer.getDeclarations().select(this.VALID_DECLARATION_PREDICATE).toArray(new DataDeclaration[0]);
            ComboBox result = UiFactory.createComboBox((UiContainer)container, (Object[])validTargets);
            result.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        TransformationCanvasEditorDialog.this.resetDefaultXSLFileName();
                    }
                }
            });
            result.setLabelProvider(this.createDataDeclarationLabelProvider());
            return result;
        }

        private LabelProvider<DataDeclaration> createDataDeclarationLabelProvider() {
            return new LabelProvider<DataDeclaration>(){
                private DataDeclarationRenderer renderer = new DataDeclarationRenderer();

                public Image getIcon(DataDeclaration element) {
                    return this.renderer.getIcon(element);
                }

                public String getText(DataDeclaration element) {
                    return this.renderer.getLabel(element);
                }
            };
        }

        private void resetDefaultXSLFileName() {
            this.transformationTextField.setText(this.getDefaultXSLFileName());
        }

        private TextField createTransformationTextField(@NotNull UiContainer container) {
            return new ValidFileTextField(container, "", 0, 128, false);
        }

        private ComboBox<XSLTransformation> createTransformationComboBox(@NotNull UiContainer container, @NotNull XSLTransformationsContainer xslTransformationsContainer) {
            Sequence xslTransformationsSequence = xslTransformationsContainer.getChildrenByType(XSLTransformation.class);
            XSLTransformation[] xslTransformations = xslTransformationsSequence.toArray(new XSLTransformation[0]);
            return UiFactory.createComboBox((UiContainer)container, Arrays.asList(xslTransformations));
        }

        private RadioButton createCreateNewRadio(@NotNull UiContainer container) {
            final RadioButton result = new RadioButton(container, DesignerMsg.CREATE);
            result.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TransformationCanvasEditorDialog.this.toogleCreateNewUseExistent(result.isSelected());
                }
            });
            return result;
        }

        private RadioButton createUseExistingRadio(@NotNull UiContainer container) {
            final RadioButton result = new RadioButton(container, DesignerMsg.USE_EXISTING);
            result.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TransformationCanvasEditorDialog.this.toogleCreateNewUseExistent(!result.isSelected());
                }
            });
            return result;
        }

        private void toogleCreateNewUseExistent(boolean createNew) {
            this.transformationTextField.setEnabled(createNew);
            this.tranformationComboBox.setEnabled(!createNew);
        }

        private String getDefaultXSLFileName() {
            String sourceName = !this.sourcesList.getSelectedItems().isEmpty() ? ((DataDeclaration)this.sourcesList.getSelectedItems().iterator().next()).getNativeName() : null;
            String targetName = this.targetComboBox.getSelectedItem() != null ? ((DataDeclaration)this.targetComboBox.getSelectedItem()).getNativeName() : null;
            return sourceName != null && targetName != null ? sourceName + "_" + targetName : "";
        }
    }
}

