/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.designer.expression.ExpressionBuilderDialog;
import oracle.bpm.designer.expression.ExpressionBuilderFactory;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import oracle.tip.tools.ide.assign.panel.CanvasEditorInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionCanvasEditor
implements CanvasEditorInterface {
    private DataDeclarationContainer context;
    private ExpressionMode defaultMode;

    public ExpressionCanvasEditor(@NotNull DataDeclarationContainer context, @NotNull ExpressionMode defaultMode) {
        this.context = context;
        this.defaultMode = defaultMode;
    }

    public Object createCanvasObject(Object toModelNode) {
        DataDeclarationTreeNode toNode = null;
        if (toModelNode instanceof DataDeclarationTreeNode) {
            toNode = (DataDeclarationTreeNode)toModelNode;
        }
        return this.getExpressionFromBuilder(null, toNode);
    }

    public Object modifyCanvasObject(Object canvasObject, Object toModelNode) {
        Expression expression = (Expression)canvasObject;
        DataDeclarationTreeNode toNode = (DataDeclarationTreeNode)toModelNode;
        return this.getExpressionFromBuilder(expression, toNode);
    }

    private Expression getExpressionFromBuilder(@Nullable Expression expression, @Nullable DataDeclarationTreeNode toNode) {
        Expression result = null;
        CatalogType resultType = null;
        if (toNode != null) {
            DataDeclaration toDeclaration = toNode.getDataDeclaration();
            resultType = toDeclaration.getType();
        }
        ExpressionBuilderDialog dialog = ExpressionBuilderFactory.createDataAssociationExpressionBuilder((UiWindow)Ui.getRoot(), (ExpressionMode)this.defaultMode, (ExpressionContext)new ExpressionContext(this.context, resultType), (Expression)expression);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            result = dialog.getExpression();
        }
        return result;
    }
}

