/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.XSLTransformationService;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationCanvasType;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.tree.TreeNode;
import oracle.tip.tools.ide.assign.panel.TreeModelInfoInterface;
import org.jetbrains.annotations.NotNull;

public class DataDeclarationTreeModelInfo
implements TreeModelInfoInterface {
    public String getModelTreeNodePath(Object modelTreeNode) {
        return this.getModelTreeNodeTreePath(modelTreeNode).toString();
    }

    public TreePath getModelTreeNodeTreePath(Object modelTreeNode) {
        ArrayList<TreeNode> pathStack = new ArrayList<TreeNode>();
        for (TreeNode element = (TreeNode)modelTreeNode; element != null; element = element.getParent()) {
            pathStack.add(0, element);
        }
        return !pathStack.isEmpty() ? new TreePath(pathStack.toArray()) : null;
    }

    public String getModelTreeNodeToolTipText(Object modelTreeNode) {
        TreeNode treeNode = (TreeNode)modelTreeNode;
        return treeNode.getToolTipText();
    }

    public JPopupMenu getModelTreeNodeContextMenu(Object modelTreeNode) {
        TreeNode treeNode = (TreeNode)modelTreeNode;
        ActionGroup actions = treeNode.createActions();
        if (actions != null) {
            actions.setSelection(treeNode.getSelection());
            PopupMenu popupMenu = PopupMenu.create(null, (ActionGroup)actions);
            return (JPopupMenu)popupMenu.asSwing();
        }
        return null;
    }

    public boolean isPossibleFromNode(Object modelTreeNode) {
        boolean result = false;
        if (modelTreeNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode dataDeclarationTreeNode = (DataDeclarationTreeNode)modelTreeNode;
            result = !this.isShadowed(dataDeclarationTreeNode);
        }
        return result;
    }

    public boolean canDropFromNode(Object toModelNode, Object fromModelNode) {
        boolean result = false;
        if (fromModelNode instanceof DataDeclarationTreeNode && toModelNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode fromDeclarationNode = (DataDeclarationTreeNode)fromModelNode;
            DataDeclarationTreeNode toDeclarationNode = (DataDeclarationTreeNode)toModelNode;
            DataDeclaration toDataDeclaration = toDeclarationNode.getDataDeclaration();
            if (!this.isShadowed(toDeclarationNode) && !toDataDeclaration.isReadOnly()) {
                CatalogType fromType;
                DataDeclaration fromDeclaration = fromDeclarationNode.getDataDeclaration();
                CatalogType toType = toDataDeclaration.getType();
                result = toType.isAssignableFrom(fromType = fromDeclaration.getType());
                if (!result && toType.isArray() && !fromType.isArray()) {
                    CatalogType toElementType = toType.getElementType();
                    result = toElementType.isAssignableFrom(fromType);
                }
            }
        }
        return result;
    }

    public boolean canDropCanvasObject(Object toModelNode, Object canvasType) {
        boolean result = false;
        if (toModelNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode toNode = (DataDeclarationTreeNode)toModelNode;
            DataDeclaration toDataDeclaration = toNode.getDataDeclaration();
            if (!this.isShadowed(toNode) && !toDataDeclaration.isReadOnly()) {
                DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)canvasType);
                if (type == DataAssociationCanvasType.TRANSFORMATION) {
                    XSLTransformationService service;
                    TreeNode parent = toNode.getParent();
                    if (!(parent != null && parent instanceof DataDeclarationTreeNode || (service = AbstractStudioWorkbench.getInstance().getXSLTransformationService()) == null)) {
                        DataDeclaration toDeclaration = toNode.getDataDeclaration();
                        result = service.isValidDeclaration(toDeclaration);
                    }
                } else if (type == DataAssociationCanvasType.EXPRESSION || type == DataAssociationCanvasType.XML_LITERAL) {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean errorMessageOnDrop(Object toModelNode, Object fromModelNode) {
        return false;
    }

    private boolean isShadowed(@NotNull DataDeclarationTreeNode dataDeclarationTreeNode) {
        TreeNode root = dataDeclarationTreeNode.getRoot();
        DataDeclarationTreeNode rootDeclarationNode = this.getRootDeclarationNode(dataDeclarationTreeNode);
        String rootDeclarationName = rootDeclarationNode.getDataDeclaration().getName();
        int rootDeclarationNodeLevel = rootDeclarationNode.getLevel();
        return this.hasChildrenDeclarationName(root, rootDeclarationName, rootDeclarationNodeLevel);
    }

    private boolean hasChildrenDeclarationName(@NotNull TreeNode root, @NotNull String name, int level) {
        List children = root.getChildren();
        for (TreeNode child : children) {
            int levelFound;
            DataDeclarationTreeNode dataDeclarationTreeNode;
            DataDeclaration dataDeclaration;
            if (!(child instanceof DataDeclarationTreeNode ? name.equals((dataDeclaration = (dataDeclarationTreeNode = (DataDeclarationTreeNode)child).getDataDeclaration()).getName()) && (levelFound = dataDeclarationTreeNode.getLevel()) < level : this.hasChildrenDeclarationName(child, name, level))) continue;
            return true;
        }
        return false;
    }

    private DataDeclarationTreeNode getRootDeclarationNode(@NotNull DataDeclarationTreeNode node) {
        DataDeclarationTreeNode element = node;
        while (element.getParent() instanceof DataDeclarationTreeNode) {
            element = (DataDeclarationTreeNode)element.getParent();
        }
        return element;
    }
}

