/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationExplorerTreeNode;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTree;
import oracle.bpm.designer.flowpanels.DataAssociationsPanelOptions;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationAssignmentRule;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationCanvas;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationExpressionEditorManager;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationLine;
import oracle.bpm.fusion.studio.dataassociation.DataDeclarationTreeModelInfo;
import oracle.bpm.project.compile.process.DataAssociationHelper;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.DataAssociationEnabled;
import oracle.bpm.project.model.processes.InputDataAssociationEnabled;
import oracle.bpm.project.model.processes.OutputDataAssociationEnabled;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.TreeNode;
import oracle.tip.tools.ide.assign.panel.AssignmentRuleInterface;
import oracle.tip.tools.ide.assign.panel.CanvasTypeInterface;
import oracle.tip.tools.ide.assign.panel.ExpansionFilterInterface;
import oracle.tip.tools.ide.assign.panel.LineTypeInterface;
import oracle.tip.tools.ide.assign.panel.MapPanel;
import oracle.tip.tools.ide.assign.panel.MapPanelOptions;
import oracle.tip.tools.ide.assign.panel.RuleError;
import oracle.tip.tools.ide.assign.panel.RuleErrorType;
import oracle.tip.tools.ide.assign.panel.RuleValidationResult;
import oracle.tip.tools.ide.assign.panel.TreeModelExpansionListener;
import oracle.tip.tools.ide.assign.panel.TreeModelInfoInterface;
import oracle.tip.tools.ide.assign.panel.XPathPanelInterface;
import org.jetbrains.annotations.NotNull;

public class DataAssociationMapDialog
extends OkCancelDialog {
    private DataAssociationMapPanel inputMapPanel;
    private DataAssociationMapPanel outputMapPanel;

    public DataAssociationMapDialog(@NotNull UiWindow parent, @NotNull DataAssociationEnabled dataAssociationEnabled, @NotNull DataAssociationsPanelOptions dataAssociationsPanelOptions) {
        super(parent, DesignerMsg.DATA_ASSOCIATIONS);
        this.init(dataAssociationEnabled, dataAssociationsPanelOptions);
    }

    public void ok() {
        Msg validationMsg = this.validateInput();
        if (validationMsg == null) {
            this.applyChanges();
            this.close();
        } else {
            MessageDialog.showError((Msg)validationMsg);
        }
    }

    private void applyChanges() {
        if (this.inputMapPanel != null) {
            this.inputMapPanel.applyChanges();
        }
        if (this.outputMapPanel != null) {
            this.outputMapPanel.applyChanges();
        }
    }

    private Msg validateInput() {
        Msg result = null;
        if (this.inputMapPanel != null) {
            result = this.validateMapPanel(this.inputMapPanel, DesignerMsg.INPUT);
        }
        if (result == null && this.outputMapPanel != null) {
            result = this.validateMapPanel(this.outputMapPanel, DesignerMsg.OUTPUT);
        }
        return result;
    }

    private Msg validateMapPanel(@NotNull DataAssociationMapPanel mapPanel, @NotNull Msg endpoint) {
        if (!mapPanel.isValid()) {
            return DesignerMsg.INVALID_DATA_ASSOCIATIONS((Msg)endpoint);
        }
        if (mapPanel.hasOrphans()) {
            return DesignerMsg.ORPHAN_CANVAS_OBJECTS((Msg)endpoint);
        }
        return null;
    }

    private void init(@NotNull DataAssociationEnabled dataAssociationEnabled, @NotNull DataAssociationsPanelOptions dataAssociationsPanelOptions) {
        UiContainer panel = this.getContentPane();
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        if (dataAssociationsPanelOptions.isDraft()) {
            Label label = Label.createWithNoColon((UiContainer)panel, (Msg)DesignerMsg.DRAFT_ASSOCIATIONS);
            label.setIcon(Image.create((Msg)UIMsg.DRAFT));
            label.setForeground(Color.RED);
            panel.add((UiComponent)label, (Object)"wrap");
        }
        TabbedPane tabbedPane = new TabbedPane(panel);
        panel.add((UiComponent)tabbedPane, (Object)"grow");
        if (InputDataAssociationEnabled.class.isAssignableFrom(dataAssociationEnabled.getRawClass())) {
            InputDataAssociationEnabled inputDataAssociationEnabled = (InputDataAssociationEnabled)dataAssociationEnabled;
            DataAssociationSet inputDataAssociationSet = inputDataAssociationEnabled.getInputDataAssociationSet();
            this.inputMapPanel = DataAssociationMapPanel.create((UiContainer)tabbedPane, inputDataAssociationSet);
            tabbedPane.addTab(DesignerMsg.INPUT, (UiComponent)this.inputMapPanel);
        }
        if (OutputDataAssociationEnabled.class.isAssignableFrom(dataAssociationEnabled.getRawClass())) {
            OutputDataAssociationEnabled outputDataAssociationEnabled = (OutputDataAssociationEnabled)dataAssociationEnabled;
            DataAssociationSet outputDataAssociationSet = outputDataAssociationEnabled.getOutputDataAssociationSet();
            this.outputMapPanel = DataAssociationMapPanel.create((UiContainer)tabbedPane, outputDataAssociationSet);
            tabbedPane.addTab(DesignerMsg.OUTPUT, (UiComponent)this.outputMapPanel);
        }
        this.setSize(800, 600);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private static class DataAssociationMapPanel
    extends Panel {
        private List<DataAssociation> associationsModel;
        private DataAssociationAssignmentRule dataAssociationAssignmentRule;
        private MapPanel mapPanel;
        private DataAssociationSet set;
        private CheckBox validateAssociationCheckBox;

        private DataAssociationMapPanel(@NotNull UiContainer parent, @NotNull DataAssociationSet set) {
            super(parent);
            this.set = set;
            this.init();
        }

        public static DataAssociationMapPanel create(@NotNull UiContainer parent, @NotNull DataAssociationSet set) {
            return new DataAssociationMapPanel(parent, set);
        }

        public void applyChanges() {
            this.set.clearDataAssociations();
            for (DataAssociation dataAssociation : this.associationsModel) {
                this.set.addDataAssociation(dataAssociation);
            }
            this.set.setValidating(this.validateAssociationCheckBox.isSelected());
        }

        public boolean hasOrphans() {
            return this.mapPanel.getOrphanCount() > 0;
        }

        public boolean isValid() {
            boolean result = true;
            for (DataAssociation dataAssociation : this.associationsModel) {
                RuleValidationResult fromValidationResult = this.dataAssociationAssignmentRule.validate(dataAssociation);
                if (this.isRuleValidationResultValid(fromValidationResult)) continue;
                result = false;
                break;
            }
            return result;
        }

        private void init() {
            DataDeclarationContainer sourceContainer = this.getSourceContainer(this.set);
            DataDeclarationContainer targetContainer = this.getTargetContainer(this.set);
            DataDeclarationTree sourceTree = new DataDeclarationTree((UiContainer)Ui.getRoot(), sourceContainer);
            DataDeclarationTree targetTree = new DataDeclarationTree((UiContainer)Ui.getRoot(), targetContainer);
            TreeModel sourceModel = ((JTree)sourceTree.asSwing()).getModel();
            TreeModel targetModel = ((JTree)targetTree.asSwing()).getModel();
            TreeCellRenderer fromCellRenderer = ((JTree)sourceTree.asSwing()).getCellRenderer();
            TreeCellRenderer toCellRenderer = ((JTree)sourceTree.asSwing()).getCellRenderer();
            MapPanelOptions mapPanelOptions = new MapPanelOptions();
            mapPanelOptions.setLineTypes((LineTypeInterface)new DataAssociationLine());
            mapPanelOptions.addFromTreeCellRenderer(fromCellRenderer);
            mapPanelOptions.addToTreeCellRenderer(toCellRenderer);
            mapPanelOptions.setCanvasTypes((CanvasTypeInterface)new DataAssociationCanvas(this.set));
            mapPanelOptions.setInsertModeVisible(false);
            this.dataAssociationAssignmentRule = new DataAssociationAssignmentRule(this.set, (DataDeclarationExplorerTreeNode)sourceTree.getRoot(), (DataDeclarationExplorerTreeNode)targetTree.getRoot());
            this.mapPanel = new MapPanel(sourceModel, targetModel, mapPanelOptions);
            this.mapPanel.setTreeModelInfoInterface(0, (TreeModelInfoInterface)new DataDeclarationTreeModelInfo());
            this.mapPanel.setTreeModelInfoInterface(1, (TreeModelInfoInterface)new DataDeclarationTreeModelInfo());
            this.mapPanel.setTreeModelExpansionListener(0, (TreeModelExpansionListener)new DefaultTreeModelExpansionListener());
            this.mapPanel.setTreeModelExpansionListener(1, (TreeModelExpansionListener)new DefaultTreeModelExpansionListener());
            this.mapPanel.setAssignmentRuleInterface((AssignmentRuleInterface)this.dataAssociationAssignmentRule);
            UiContainer uiMapPanel = (UiContainer)UiComponent.get((Object)this.mapPanel);
            DataAssociationExpressionEditorManager dataAssociationExpressionEditorManager = new DataAssociationExpressionEditorManager(uiMapPanel, this.set);
            DataAssociationExpressionEditorManager.DataAssociationExpressionEditor fromEditor = dataAssociationExpressionEditorManager.getFromExpressionEditor();
            DataAssociationExpressionEditorManager.DataAssociationExpressionEditor toEditor = dataAssociationExpressionEditorManager.getToExpressionEditor();
            this.mapPanel.setXPathPanel((XPathPanelInterface)fromEditor, (XPathPanelInterface)toEditor);
            mapPanelOptions.setTreeExpansionLevel(2);
            mapPanelOptions.setTreeExpansionFilter(new ExpansionFilterInterface(){

                public boolean expandNode(Object modelNode) {
                    TreeNode treeNode = (TreeNode)modelNode;
                    return DataDeclarationTree.isAutomaticExpandable((TreeNode)treeNode);
                }
            });
            this.associationsModel = this.createModel(this.set);
            this.mapPanel.initialize(this.associationsModel);
            this.addListenerToTreeModel(sourceModel);
            this.addListenerToTreeModel(targetModel);
            this.setLayout((Layout)new BorderLayout(0, 5));
            this.add((UiComponent)uiMapPanel, "Center");
            Msg msg = this.set.isInput() ? DesignerMsg.VALIDATE_INPUT_DATA_ASSOCIATIONS : DesignerMsg.VALIDATE_OUTPUT_DATA_ASSOCIATIONS;
            this.validateAssociationCheckBox = CheckBox.create((UiContainer)this, (Msg)msg, (boolean)this.set.isValidating());
            this.add((UiComponent)this.validateAssociationCheckBox, "South");
        }

        private void addListenerToTreeModel(@NotNull TreeModel model) {
            model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    DataAssociationMapPanel.this.revalidateExpressions();
                    DataAssociationMapPanel.this.mapPanel.refreshTable();
                    DataAssociationMapPanel.this.mapPanel.redrawMapPanel();
                }
            });
        }

        private void revalidateExpressions() {
            for (DataAssociation association : this.associationsModel) {
                if (!association.isDataAssignment()) continue;
                DataAssignment dataAssignment = (DataAssignment)association.as(DataAssignment.class);
                DataAssociationHelper.revalidateDataAssociationItem((DataAssignmentItem)dataAssignment.getSource());
                DataAssociationHelper.revalidateDataAssociationItem((DataAssignmentItem)dataAssignment.getTarget());
            }
        }

        private List<DataAssociation> createModel(@NotNull DataAssociationSet set) {
            ArrayList<DataAssociation> result = new ArrayList<DataAssociation>();
            for (DataAssociation dataAssociation : set.getDataAssociations()) {
                if (dataAssociation.isDataAssignment()) {
                    DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                    DataAssignment newDataAssignment = set.createDataAssignment(dataAssignment.getSource().getExpression(), dataAssignment.getTarget().getExpression());
                    newDataAssignment.setOperation(dataAssignment.getOperation());
                    result.add((DataAssociation)newDataAssignment);
                    continue;
                }
                if (!dataAssociation.isDataTransformation()) continue;
                DataTransformation dataTransformation = (DataTransformation)dataAssociation.as(DataTransformation.class);
                DataTransformation newDataTransformation = set.createDataTransformation(dataTransformation.getSourceRefs(), dataTransformation.getTargetRef(), dataTransformation.getTransformationName());
                result.add((DataAssociation)newDataTransformation);
            }
            return result;
        }

        private DataDeclarationContainer getSourceContainer(@NotNull DataAssociationSet set) {
            return set.getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
        }

        private DataDeclarationContainer getTargetContainer(@NotNull DataAssociationSet set) {
            return set.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
        }

        private boolean isRuleValidationResultValid(@NotNull RuleValidationResult validationResult) {
            List errors = validationResult.getErrors();
            for (RuleError error : errors) {
                if (error.getType() != RuleErrorType.ERROR) continue;
                return false;
            }
            return true;
        }

        private static class DefaultTreeModelExpansionListener
        implements TreeModelExpansionListener {
            private DefaultTreeModelExpansionListener() {
            }

            public void expandTreeModelNode(Object parentNode) {
                TreeNode treeNode = (TreeNode)parentNode;
                if (treeNode != null) {
                    treeNode.expand();
                }
            }

            public boolean expandRequiresUpdate(Object parentNode) {
                return false;
            }
        }
    }
}

