/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bpm.designer.expression.ExpressionContainerListener;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.MigLayout;
import oracle.tip.tools.ide.assign.panel.XPathPanelInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataAssociationExpressionEditorManager {
    private DataAssociationExpressionEditor fromExpressionEditor;
    private DataAssociationExpressionEditor toExpressionEditor;

    public DataAssociationExpressionEditorManager(@NotNull UiContainer container, @NotNull DataAssociationSet set) {
        this.fromExpressionEditor = DataAssociationExpressionEditor.DataAssociationFromExpressionEditor.create(container, set);
        this.toExpressionEditor = DataAssociationExpressionEditor.DataAssociationToExpressionEditor.create(container, set);
        this.toExpressionEditor.addListener(new XPathPanelInterface.XPathPanelListener(){

            public void pathChanged() {
                CatalogType type = DataAssociationExpressionEditorManager.this.toExpressionEditor.getResultType();
                DataAssociationExpressionEditorManager.this.fromExpressionEditor.setResultType(type);
            }
        });
    }

    public DataAssociationExpressionEditor getFromExpressionEditor() {
        return this.fromExpressionEditor;
    }

    public DataAssociationExpressionEditor getToExpressionEditor() {
        return this.toExpressionEditor;
    }

    public static abstract class DataAssociationExpressionEditor
    extends JPanel
    implements XPathPanelInterface {
        private ExpressionPanel delegate;
        private ExpressionContext expressionContext;
        private ArrayList<XPathPanelInterface.XPathPanelListener> listeners = new ArrayList();

        protected DataAssociationExpressionEditor(@NotNull UiContainer container, @NotNull ExpressionContext expressionContext, @NotNull Msg msg) {
            this.expressionContext = expressionContext;
            this.init(container, msg);
        }

        public CatalogType getResultType() {
            CatalogType result = null;
            Expression expression = this.delegate.getExpression();
            if (expression != null) {
                result = ExpressionHelper.getExpressionType((Expression)expression, (ExpressionContext)this.expressionContext);
            }
            return result;
        }

        public String getText() {
            Expression expression = this.delegate.getExpression();
            return expression != null ? ExpressionHelper.getText((Expression)expression, (ExpressionContext)this.expressionContext) : "";
        }

        public Object getValue() {
            return this.delegate.getExpression();
        }

        public void clearValue() {
            this.delegate.setExpression(null);
        }

        public Object setValueFromRule(Object rule) {
            Expression result = null;
            if (rule instanceof DataAssignment) {
                DataAssignment dataAssignment = (DataAssignment)rule;
                Expression expression = this.getExpressionFromAssociation(dataAssignment);
                this.delegate.setExpression(expression);
                result = expression;
            }
            return result;
        }

        public void setResultType(@Nullable CatalogType resultType) {
            this.expressionContext.setResultType(resultType);
            this.delegate.setContext(this.expressionContext);
        }

        public void addListener(XPathPanelInterface.XPathPanelListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(XPathPanelInterface.XPathPanelListener listener) {
            this.listeners.remove(listener);
        }

        public JComponent getJComponent() {
            return this;
        }

        protected abstract Expression getExpressionFromAssociation(@NotNull DataAssignment var1);

        private void init(@NotNull UiContainer container, @NotNull Msg msg) {
            this.setLayout((LayoutManager)new MigLayout("ins 0, gap 5, fillx"));
            Label label = Label.create((UiContainer)container, (Msg)msg);
            this.add(label.asSwing());
            this.delegate = ExpressionPanelFactory.createDataAssociationPanel((UiContainer)container, (ExpressionContext)this.expressionContext);
            JComponent jComponent = this.delegate.getUiComponent().asSwing();
            this.add((Component)jComponent, "growx");
            this.delegate.addListener(new ExpressionContainerListener(){

                public void expressionChanged() {
                    DataAssociationExpressionEditor.this.fireExpressionChanged();
                }
            });
            JTextField tf = new JTextField();
            tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            });
        }

        private void fireExpressionChanged() {
            if (this.isVisible()) {
                for (XPathPanelInterface.XPathPanelListener listener : this.listeners) {
                    listener.pathChanged();
                }
            }
        }

        private static class DataAssociationToExpressionEditor
        extends DataAssociationExpressionEditor {
            protected DataAssociationToExpressionEditor(@NotNull UiContainer container, @NotNull ExpressionContext expressionContext, @NotNull Msg msg) {
                super(container, expressionContext, msg);
            }

            public static DataAssociationToExpressionEditor create(@NotNull UiContainer container, @NotNull DataAssociationSet set) {
                DataDeclarationContainer toDataDeclarationContainer = set.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
                ExpressionContext context = new ExpressionContext(toDataDeclarationContainer, true);
                return new DataAssociationToExpressionEditor(container, context, DesignerMsg.TO);
            }

            @Override
            protected Expression getExpressionFromAssociation(@NotNull DataAssignment dataAssignment) {
                return dataAssignment.getTarget().getExpression();
            }
        }

        private static class DataAssociationFromExpressionEditor
        extends DataAssociationExpressionEditor {
            protected DataAssociationFromExpressionEditor(@NotNull UiContainer container, @NotNull ExpressionContext expressionContext, @NotNull Msg msg) {
                super(container, expressionContext, msg);
            }

            public static DataAssociationFromExpressionEditor create(@NotNull UiContainer container, @NotNull DataAssociationSet set) {
                DataDeclarationContainer fromDataDeclarationContainer = set.getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
                ExpressionContext context = new ExpressionContext(fromDataDeclarationContainer);
                return new DataAssociationFromExpressionEditor(container, context, DesignerMsg.FROM);
            }

            @Override
            protected Expression getExpressionFromAssociation(@NotNull DataAssignment dataAssignment) {
                return dataAssignment.getSource().getExpression();
            }
        }
    }
}

