/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import java.util.HashMap;
import javax.swing.ImageIcon;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationCanvasType;
import oracle.bpm.fusion.studio.dataassociation.ExpressionCanvasEditor;
import oracle.bpm.fusion.studio.dataassociation.TransformationCanvasEditor;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentOperation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.tip.tools.ide.assign.panel.CanvasEditorInterface;
import oracle.tip.tools.ide.assign.panel.CanvasTypeInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataAssociationCanvas
implements CanvasTypeInterface {
    private HashMap<DataAssociationCanvasType, CanvasData> canvasDataMap = new HashMap();

    public DataAssociationCanvas(@NotNull DataAssociationSet dataAssociationSet) {
        DataDeclarationContainer sourceContainer = dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE);
        ExpressionMode defaultMode = DesignerPreferences.getPreferences().getExpressionMode();
        this.canvasDataMap.put(DataAssociationCanvasType.EXPRESSION, new CanvasData(DesignerMsg.DATA_ASSOCIATION_EXPRESSION_CANVAS, new ExpressionCanvasEditor(sourceContainer, defaultMode), DataAssignmentOperation.getDefault()));
        this.canvasDataMap.put(DataAssociationCanvasType.XML_LITERAL, new CanvasData(LibMsg.XML_LITERAL, new ExpressionCanvasEditor(sourceContainer, ExpressionMode.XML_LITERAL), DataAssignmentOperation.getDefault()));
        this.canvasDataMap.put(DataAssociationCanvasType.TRANSFORMATION, new CanvasData(DesignerMsg.XSL_TRANSFORMATION, new TransformationCanvasEditor(dataAssociationSet), null));
    }

    public Object[] getSupportedCanvasTypes() {
        return new DataAssociationCanvasType[]{DataAssociationCanvasType.EXPRESSION, DataAssociationCanvasType.XML_LITERAL, DataAssociationCanvasType.TRANSFORMATION};
    }

    public ImageIcon getCanvasTypeIcon(Object o) {
        DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)o);
        Image icon = this.canvasDataMap.get((Object)type).getIcon();
        return icon.asSwingImageIcon();
    }

    public String getCanvasTypeIconToolTip(Object o) {
        DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)o);
        return this.canvasDataMap.get((Object)type).getToolTip();
    }

    public CanvasEditorInterface getCanvasEditor(Object o) {
        DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)o);
        return this.canvasDataMap.get((Object)type).getEditor();
    }

    public Object getDefaultLineTypeForCanvasType(Object o) {
        DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)o);
        return this.canvasDataMap.get((Object)type).getDefaultOperation();
    }

    public boolean isCanvasObjectXPath(Object canvasType) {
        return false;
    }

    public boolean allowsOrphanCanvasObject(Object canvasType) {
        DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)canvasType);
        return type != DataAssociationCanvasType.TRANSFORMATION;
    }

    private static class CanvasData {
        private DataAssignmentOperation defaultOperation;
        private CanvasEditorInterface editor;
        private Msg message;

        public CanvasData(@NotNull Msg message, @NotNull CanvasEditorInterface editor, @Nullable DataAssignmentOperation defaultOperation) {
            this.message = message;
            this.defaultOperation = defaultOperation;
            this.editor = editor;
        }

        public String getToolTip() {
            return this.message.getString();
        }

        public Image getIcon() {
            return Image.create((Msg)this.message);
        }

        public CanvasEditorInterface getEditor() {
            return this.editor;
        }

        public DataAssignmentOperation getDefaultOperation() {
            return this.defaultOperation;
        }
    }
}

