/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.dataassociation;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationExplorerTreeNode;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationCanvasType;
import oracle.bpm.fusion.studio.dataassociation.DataAssociationValidationResult;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.DataAssociationHelper;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.validator.DataAssignmentValidator;
import oracle.bpm.project.compile.validator.DataTransformationValidator;
import oracle.bpm.project.compile.validator.ValidationType;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.dataassociations.DataAssignment;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssignmentOperation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.tip.tools.ide.assign.panel.AssignmentRuleInterface;
import oracle.tip.tools.ide.assign.panel.LineEditorInterface;
import oracle.tip.tools.ide.assign.panel.NodeEditorInterface;
import oracle.tip.tools.ide.assign.panel.RuleErrorSource;
import oracle.tip.tools.ide.assign.panel.RuleErrorType;
import oracle.tip.tools.ide.assign.panel.RuleValidationResult;
import org.jetbrains.annotations.NotNull;

public class DataAssociationAssignmentRule
implements AssignmentRuleInterface {
    private DataAssociationSet dataAssociationSet;
    private DataDeclarationExplorerTreeNode fromRootTreeNode;
    private DataDeclarationExplorerTreeNode toRootTreeNode;

    public DataAssociationAssignmentRule(@NotNull DataAssociationSet dataAssociationSet, @NotNull DataDeclarationExplorerTreeNode fromRootTreeNode, @NotNull DataDeclarationExplorerTreeNode toRootTreeNode) {
        this.dataAssociationSet = dataAssociationSet;
        this.fromRootTreeNode = fromRootTreeNode;
        this.toRootTreeNode = toRootTreeNode;
    }

    public Object createRule(Object lineType, Object fromModelNode, Object fromPath, Object toModelNode, Object toPath) {
        DataAssignment result = null;
        Expression fromExpression = null;
        Expression toExpression = null;
        if (fromPath != null && toPath != null) {
            fromExpression = (Expression)fromPath;
            toExpression = (Expression)toPath;
        } else if (toModelNode instanceof DataDeclarationTreeNode && fromModelNode instanceof DataDeclarationTreeNode) {
            DataDeclarationTreeNode toDataDeclarationTreeNode = (DataDeclarationTreeNode)toModelNode;
            DataDeclarationTreeNode fromDataDeclarationTreeNode = (DataDeclarationTreeNode)fromModelNode;
            CatalogType toType = toDataDeclarationTreeNode.getDataDeclaration().getType();
            CatalogType fromType = fromDataDeclarationTreeNode.getDataDeclaration().getType();
            DataDeclarationContainer toContext = this.dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
            Sequence toParts = toDataDeclarationTreeNode.getDeclarationsPath();
            Sequence fromParts = fromDataDeclarationTreeNode.getDeclarationsPath();
            ExpressionMode defaultMode = DesignerPreferences.getPreferences().getExpressionMode();
            boolean selectFirstElement = false;
            if (!fromType.isArray() && toType.isArray()) {
                toType = toType.getElementType();
                selectFirstElement = true;
            }
            toExpression = ExpressionHelper.createExpressionFromParts((ExpressionMode)defaultMode, (Sequence)toParts, (ExpressionContext)new ExpressionContext(toContext, true), (boolean)selectFirstElement);
            fromExpression = ExpressionHelper.createExpressionFromParts((ExpressionMode)defaultMode, (Sequence)fromParts, (ExpressionContext)new ExpressionContext(this.dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.SOURCE), toType));
        }
        if (fromExpression != null && toExpression != null) {
            result = this.dataAssociationSet.createDataAssignment(fromExpression, toExpression);
            DataAssignmentOperation operation = (DataAssignmentOperation)lineType;
            if (operation != null) {
                result.setOperation(operation);
            }
        }
        return result;
    }

    public Object createCanvasRule(Object lineType, Object canvasType, Object canvasObject, Object toModelNode, Object toPath) {
        DataTransformation result = null;
        if (canvasObject != null) {
            DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)canvasType);
            ExpressionMode defaultMode = DesignerPreferences.getPreferences().getExpressionMode();
            if (type == DataAssociationCanvasType.EXPRESSION || type == DataAssociationCanvasType.XML_LITERAL) {
                Expression fromExpression = (Expression)canvasObject;
                Expression toExpression = null;
                if (toPath != null) {
                    toExpression = (Expression)toPath;
                } else if (toModelNode != null && toModelNode instanceof DataDeclarationTreeNode) {
                    DataDeclarationTreeNode toDataDeclarationTreeNode = (DataDeclarationTreeNode)toModelNode;
                    Sequence toParts = toDataDeclarationTreeNode.getDeclarationsPath();
                    DataDeclarationContainer toContext = this.dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
                    toExpression = ExpressionHelper.createExpressionFromParts((ExpressionMode)defaultMode, (Sequence)toParts, (ExpressionContext)new ExpressionContext(toContext, true));
                }
                if (toExpression != null) {
                    DataAssignment dataAssignment = this.dataAssociationSet.createDataAssignment(fromExpression, toExpression);
                    DataAssignmentOperation operation = (DataAssignmentOperation)lineType;
                    dataAssignment.setOperation(operation);
                    result = dataAssignment;
                }
            } else if (type == DataAssociationCanvasType.TRANSFORMATION) {
                result = (DataTransformation)canvasObject;
            }
        }
        return result;
    }

    public Object createLineEditorRule(Object lineType, Object lineObject, Object fromModelNode, Object fromPath, Object toModelNode, Object toPath) {
        return null;
    }

    public Object getFromModelNode(Object rule) {
        DataAssignment dataAssignment;
        DataAssignmentItem item;
        Expression expression;
        DataAssociation dataAssociation;
        DataDeclarationTreeNode result = null;
        if (rule instanceof DataAssociation && (dataAssociation = (DataAssociation)rule).isDataAssignment() && (expression = (item = (dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class)).getSource()).getExpression()) != null) {
            Sequence fromParts = ExpressionHelper.getDeclarationsPath((Expression)expression, (ExpressionContext)new ExpressionContext(item.getContext()));
            result = this.findDataDeclarationTreeNodeByPath(fromParts, this.fromRootTreeNode);
        }
        return result;
    }

    public String getFromText(Object rule) {
        String result = null;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                DataAssignmentItem item = dataAssignment.getSource();
                result = item.getText();
            } else if (dataAssociation.isDataTransformation()) {
                DataTransformation dataTransformation = (DataTransformation)dataAssociation.as(DataTransformation.class);
                result = dataTransformation.getTransformationName();
            }
        }
        return result;
    }

    public String getFromToolTip(Object rule) {
        return this.getFromText(rule);
    }

    public String getFromPath(Object rule) {
        return null;
    }

    public Object setFromPath(Object rule, Object fromPath) {
        DataAssociation dataAssociation;
        DataAssignment result = null;
        if (rule instanceof DataAssociation && (dataAssociation = (DataAssociation)rule).isDataAssignment()) {
            DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
            Expression fromExpression = (Expression)fromPath;
            DataAssignmentItem source = dataAssignment.getSource();
            source.setExpression(fromExpression);
            result = dataAssignment;
        }
        return result;
    }

    public Icon getFromIcon(Object rule) {
        Icon result = null;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                Expression fromExpression = dataAssignment.getSource().getExpression();
                if (fromExpression != null) {
                    DataDeclarationTreeNode node = (DataDeclarationTreeNode)this.getFromModelNode(rule);
                    result = node != null ? node.getIcon().asSwingIcon() : (fromExpression.getMode() == ExpressionMode.XML_LITERAL ? Image.create((Msg)LibMsg.XML_LITERAL).asSwingImageIcon() : Image.create((Msg)DesignerMsg.EXPRESSION_BUILDER).asSwingImageIcon());
                }
            } else if (dataAssociation.isDataTransformation()) {
                result = Image.create((Msg)DesignerMsg.XSL_TRANSFORMATION).asSwingImageIcon();
            }
        }
        return result;
    }

    public Object getToModelNode(Object rule) {
        DataDeclarationTreeNode result = null;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                DataAssignmentItem item = dataAssignment.getTarget();
                Expression expression = item.getExpression();
                if (expression != null) {
                    Sequence toParts = ExpressionHelper.getDeclarationsPath((Expression)expression, (ExpressionContext)new ExpressionContext(item.getContext()));
                    result = this.findDataDeclarationTreeNodeByPath(toParts, this.toRootTreeNode);
                }
            } else if (dataAssociation.isDataTransformation()) {
                DataTransformation dataTransformation = (DataTransformation)dataAssociation.as(DataTransformation.class);
                String targetRef = dataTransformation.getTargetRef();
                DataDeclarationContainer targetContainer = this.dataAssociationSet.getDataDeclarationContainer(DataAssignmentItemEndpoint.TARGET);
                DataDeclaration dataDeclaration = targetContainer.findDeclaration(targetRef);
                if (dataDeclaration != null) {
                    result = this.findDataDeclarationTreeNodeByPath(CollectionUtils.singletonSequence(dataDeclaration), this.toRootTreeNode);
                }
            }
        }
        return result;
    }

    public String getToText(Object rule) {
        String result = null;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                DataAssignmentItem item = dataAssignment.getTarget();
                result = item.getText();
            } else if (dataAssociation.isDataTransformation()) {
                DataTransformation dataTransformation = (DataTransformation)dataAssociation.as(DataTransformation.class);
                result = dataTransformation.getTargetRef();
            }
        }
        return result;
    }

    public String getToToolTip(Object rule) {
        return this.getToText(rule);
    }

    public String getToPath(Object rule) {
        return null;
    }

    public Object setToPath(Object rule, Object toPath) {
        DataAssociation dataAssociation;
        DataAssignment result = null;
        if (rule instanceof DataAssociation && (dataAssociation = (DataAssociation)rule).isDataAssignment()) {
            DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
            Expression toExpression = (Expression)toPath;
            DataAssignmentItem target = dataAssignment.getTarget();
            target.setExpression(toExpression);
            DataAssociationHelper.revalidateDataAssociationItem((DataAssignmentItem)dataAssignment.getSource());
            result = dataAssignment;
        }
        return result;
    }

    public Icon getToIcon(Object rule) {
        Icon result = null;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                Expression fromExpression = dataAssignment.getTarget().getExpression();
                if (fromExpression != null) {
                    result = this.getToModelNodeIcon(rule);
                }
            } else {
                DataTransformation dataTransformation = (DataTransformation)dataAssociation.as(DataTransformation.class);
                if (dataTransformation.getTargetRef() != null) {
                    result = this.getToModelNodeIcon(rule);
                }
            }
        }
        return result;
    }

    public Object getLineType(Object rule) {
        DataAssociation dataAssociation;
        DataAssignmentOperation result = null;
        if (rule instanceof DataAssociation && (dataAssociation = (DataAssociation)rule).isDataAssignment()) {
            DataAssignment dataAssignment = (DataAssignment)dataAssociation;
            result = dataAssignment.getOperation();
        }
        return result;
    }

    public Object getCanvasType(Object rule) {
        DataAssociationCanvasType result = null;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation;
                Expression expression = dataAssignment.getSource().getExpression();
                result = expression != null && expression.getMode() == ExpressionMode.XML_LITERAL ? DataAssociationCanvasType.XML_LITERAL : DataAssociationCanvasType.EXPRESSION;
            } else if (dataAssociation.isDataTransformation()) {
                result = DataAssociationCanvasType.TRANSFORMATION;
            }
        }
        return result;
    }

    public Object getCanvasObject(Object rule) {
        Object result = null;
        if (this.isCanvasRule(rule)) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                result = dataAssignment.getSource().getExpression();
            } else if (dataAssociation.isDataTransformation()) {
                result = dataAssociation.as(DataTransformation.class);
            }
        }
        return result;
    }

    public String getCanvasObjectText(Object rule) {
        return this.getFromText(rule);
    }

    public String getCanvasObjectToolTip(Object rule) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        DataAssociationCanvasType type = (DataAssociationCanvasType)((Object)this.getCanvasType(rule));
        if (type == DataAssociationCanvasType.EXPRESSION) {
            sb.append("<table border=0 width=450><tr><td align=center><b>");
            sb.append(DesignerMsg.EXPRESSION.getString());
            sb.append("</b><</td></tr><tr><td align=center>");
            sb.append(Str.convertToHTMLString(this.getFromText(rule)));
            sb.append("</td></tr></table>");
        } else if (type == DataAssociationCanvasType.XML_LITERAL) {
            sb.append("<table border=0 width=450><tr><td align=center><b>");
            sb.append(LibMsg.XML_LITERAL.getString());
            sb.append("</b></td></tr><tr><td>");
            sb.append(Str.convertToHTMLString(this.getFromText(rule)));
            sb.append("</td></tr></table>");
        } else if (type == DataAssociationCanvasType.TRANSFORMATION) {
            DataTransformation dataTransformation = (DataTransformation)rule;
            sb.append("<table width=450><tr><td align=center><b>");
            sb.append(DesignerMsg.XSL_TRANSFORMATION.getString());
            sb.append("</b></td></tr>");
            sb.append("</table>");
            sb.append("<table>");
            Sequence sources = dataTransformation.getSourceRefs();
            sb.append("<tr><td><b>").append(CoreMsg.COLON(DesignerMsg.SOURCES.getString())).append("</b></td>");
            boolean firstSource = true;
            for (String source : sources) {
                if (!firstSource) {
                    sb.append("<tr><td/>");
                } else {
                    firstSource = false;
                }
                sb.append("<td>").append(source).append("</td></tr>");
            }
            sb.append("<tr><td><b>").append(CoreMsg.COLON(DesignerMsg.TARGET.getString())).append("</b></td>");
            sb.append("<td>").append(dataTransformation.getTargetRef()).append("</td></tr>");
            sb.append("<tr><td><b>").append(CoreMsg.COLON(DesignerMsg.TRANSFORMATION.getString())).append("</b></td>");
            sb.append("<td>").append(dataTransformation.getTransformationName()).append("</td></tr>");
            sb.append("</table>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public boolean isCanvasRule(Object rule) {
        boolean result = false;
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            result = dataAssociation.isDataTransformation() || dataAssociation.isDataAssignment() && this.getFromModelNode(rule) == null;
        }
        return result;
    }

    public boolean isLineEditorRule(Object rule) {
        return false;
    }

    public Object getLineObject(Object rule) {
        return null;
    }

    public boolean showFromPath(Object rule) {
        DataAssociation dataAssociation = (DataAssociation)rule;
        return dataAssociation.isDataAssignment();
    }

    public boolean showToPath(Object rule) {
        DataAssociation dataAssociation = (DataAssociation)rule;
        return dataAssociation.isDataAssignment();
    }

    public LineEditorInterface getLineEditor(Object fromModelNode, Object toModelNode) {
        return null;
    }

    public Object[] getPossibleLineTypes(Object rule) {
        DataAssociation dataAssociation;
        Object[] result = new Object[]{};
        if (rule instanceof DataAssociation && (dataAssociation = (DataAssociation)rule).isDataAssignment()) {
            DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
            DataAssignmentOperation currentOperation = dataAssignment.getOperation();
            ArrayList<DataAssignmentOperation> validOperations = new ArrayList<DataAssignmentOperation>();
            for (DataAssignmentOperation operation : DataAssignmentOperation.values()) {
                if (currentOperation == operation) continue;
                validOperations.add(operation);
            }
            result = validOperations.toArray();
        }
        return result;
    }

    public NodeEditorInterface getFromNodeEditor(Object rule) {
        return null;
    }

    public NodeEditorInterface getToNodeEditor(Object rule) {
        return null;
    }

    public void setCanvasObject(Object rule, Object canvasObject) {
        if (canvasObject != null && rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                Expression sourceExpression = (Expression)canvasObject;
                DataAssignmentItem item = dataAssignment.getSource();
                item.setExpression(sourceExpression);
            } else if (dataAssociation.isDataTransformation()) {
                // empty if block
            }
        }
    }

    public Object setLineType(Object rule, Object lineType) {
        DataAssociation dataAssociation;
        if (rule instanceof DataAssociation && (dataAssociation = (DataAssociation)rule).isDataAssignment()) {
            DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
            DataAssignmentOperation operation = (DataAssignmentOperation)lineType;
            dataAssignment.setOperation(operation);
        }
        return rule;
    }

    public JPopupMenu getContextMenu(Object rule) {
        return null;
    }

    public RuleValidationResult validate(Object rule) {
        DataAssociationValidationResult result = new DataAssociationValidationResult(DesignerMsg.DATA_ASSOCIATION_VALIDATION.getString());
        if (rule instanceof DataAssociation) {
            DataAssociation dataAssociation = (DataAssociation)rule;
            if (dataAssociation.isDataAssignment()) {
                DataAssignment dataAssignment = (DataAssignment)dataAssociation.as(DataAssignment.class);
                this.validateDataAssignment(dataAssignment, result);
            } else if (dataAssociation.isDataTransformation()) {
                DataTransformation dataTransformation = (DataTransformation)dataAssociation.as(DataTransformation.class);
                this.validateDataTransformation(dataTransformation, result);
            }
        }
        return result;
    }

    public Object getFromModelTreeNodeFromVarXPath(String xpath) {
        return null;
    }

    public String getCanvasObjectTextByType(Object canvasObject, Object canvasType) {
        return "";
    }

    public String getCanvasObjectToolTipByType(Object canvasObject, Object canvasType) {
        return "";
    }

    private void validateDataAssignment(@NotNull DataAssignment dataAssignment, @NotNull DataAssociationValidationResult result) {
        ProjectMessageListenerAdapter listener = new ProjectMessageListenerAdapter(result);
        DataAssignmentValidator validator = new DataAssignmentValidator((ProjectMessageListener)listener);
        validator.validate(dataAssignment, ValidationType.UI);
    }

    private void validateDataTransformation(@NotNull DataTransformation dataTransformation, @NotNull DataAssociationValidationResult result) {
        ProjectMessageListenerAdapter listener = new ProjectMessageListenerAdapter(result);
        DataTransformationValidator validator = new DataTransformationValidator((ProjectMessageListener)listener);
        validator.validate(dataTransformation, ValidationType.UI);
    }

    private Icon getToModelNodeIcon(Object rule) {
        DataDeclarationTreeNode node = (DataDeclarationTreeNode)this.getToModelNode(rule);
        return node != null ? node.getIcon().asSwingIcon() : Image.create((Msg)DesignerMsg.EXPRESSION_BUILDER).asSwingImageIcon();
    }

    private DataDeclarationTreeNode findDataDeclarationTreeNodeByPath(@NotNull Sequence<DataDeclaration> path, @NotNull DataDeclarationExplorerTreeNode root) {
        DataDeclarationTreeNode result = null;
        for (DataDeclaration dataDeclaration : path) {
            if ((result = result == null ? root.findDataDeclarationTreeNode(dataDeclaration) : result.findDataDeclarationTreeNode(dataDeclaration)) != null) continue;
            break;
        }
        return result;
    }

    private static class ProjectMessageListenerAdapter
    implements ProjectMessageListener {
        private DataAssociationValidationResult result;

        private ProjectMessageListenerAdapter(@NotNull DataAssociationValidationResult result) {
            this.result = result;
        }

        public void reportError(ProjectObject object, ProjectException exception) {
            this.addError(RuleErrorType.ERROR, object, exception);
        }

        public void reportWarning(ProjectObject object, ProjectException exception) {
            this.addError(RuleErrorType.WARNING, object, exception);
        }

        private void addError(@NotNull RuleErrorType type, @NotNull ProjectObject object, @NotNull ProjectException exception) {
            RuleErrorSource source = RuleErrorSource.RULE;
            if (object instanceof DataAssignmentItem) {
                DataAssignmentItem dataAssignmentItem = (DataAssignmentItem)object;
                source = dataAssignmentItem.isSource() ? RuleErrorSource.FROM : RuleErrorSource.TO;
            }
            this.result.addError(type, source, exception.getKey().getString());
        }
    }
}

