/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor.underline;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import oracle.bpm.cil.CilException;
import oracle.bpm.fusion.studio.codeeditor.FusionDocument;
import oracle.bpm.fusion.studio.codeeditor.FusionDocumentListener;
import oracle.bpm.lang.Str;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;

public class UnderlinePlugin
implements EditorPlugin,
ToolTipProvider {
    private BasicEditorPane editor;
    private HighlightStyle errorStyle;
    private HighlightLayer highlightLayer;

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        this.getDocument().addFusionDocumentListener(new FusionDocumentListener(){

            @Override
            public void compilationStarted() {
            }

            @Override
            public void compilationFinished() {
                UnderlinePlugin.this.highlightErrors();
            }
        });
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        if (this.highlightLayer != null) {
            this.editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public String getToolTipText(BasicEditorPane basicEditorPane, MouseEvent mouseEvent, int i) {
        String result;
        StringBuffer sb = new StringBuffer();
        for (CilException error : this.getDocument().getErrors()) {
            if (i < error.getOffset() || i > error.getOffset() + error.getLength()) continue;
            if (sb.length() == 0) {
                sb.append("<html><body>");
                sb.append("<table>");
            }
            sb.append("<tr><td>&nbsp;");
            URL imageURL = this.getErrorIconURL(error.isWarning());
            sb.append("<img src=").append(imageURL).append(">");
            sb.append("</td><td><b>&nbsp;");
            String description = error.getMessage();
            sb.append(description);
            sb.append("</b></td></tr>");
        }
        if (sb.length() > 0) {
            sb.append("</table>");
            sb.append("</body></html>");
        }
        return !Str.isEmpty(result = sb.toString()) ? result : null;
    }

    private URL getErrorIconURL(boolean isWarning) {
        String imageFile = isWarning ? MessageBundleUtil.getImageString((String)"LOG_WARNING_TEXT_ICON") : MessageBundleUtil.getImageString((String)"LOG_ERROR_TEXT_ICON");
        return ClassLoader.getSystemResource(imageFile);
    }

    private FusionDocument getDocument() {
        return (FusionDocument)((Object)this.editor.getDocument());
    }

    private void highlightErrors() {
        this.clearHighlights();
        for (CilException error : this.getDocument().getErrors()) {
            this.getHighlightLayer().addHighlight(this.getErrorStyle(), error.getOffset(), error.getOffset() + error.getLength());
        }
        this.editor.repaint();
    }

    private void clearHighlights() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    private HighlightStyle getErrorStyle() {
        if (this.errorStyle == null) {
            EditorProperties properties = EditorProperties.getProperties();
            HighlightRegistry registry = properties.getHighlightRegistry();
            this.errorStyle = registry.createStyle("errorStyle", "errorStyle", true, 50, null, null, 1, 4, Color.RED);
        }
        return this.errorStyle;
    }
}

