/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor.syntaxhighlight;

import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.langs.fuego.FuegoLanguageSpec;
import oracle.bpm.fusion.studio.codeeditor.syntaxhighlight.AbstractSyntax;
import org.jetbrains.annotations.NotNull;

public final class FuegoSyntax
extends AbstractSyntax {
    public static final String BPMFUEGO_COMMENT_STYLE = "bpmfuego-comment-style";
    public static final String BPMFUEGO_KEYWORD_STYLE = "bpmfuego-keyword-style";
    public static final String BPMFUEGO_IDENTIFIER_STYLE = "bpmfuego-identifier-style";
    public static final String BPMFUEGO_STRING_STYLE = "bpmfuego-string-style";
    public static final String BPMFUEGO_NUMBER_STYLE = "bpmfuego-number-style";
    public static final String BPMFUEGO_TIME_STYLE = "bpmfuego-time-style";

    public FuegoSyntax() {
        super(FuegoLanguageSpec.class);
        this.addStyle(BPMFUEGO_COMMENT_STYLE, "BPM Fuego Comment", "base-comment-style");
        this.addStyle(BPMFUEGO_KEYWORD_STYLE, "BPM Fuego Keyword", "base-keyword-style");
        this.addStyle(BPMFUEGO_IDENTIFIER_STYLE, "BPM Fuego Identifier", "base-identifier-style");
        this.addStyle(BPMFUEGO_STRING_STYLE, "BPM Fuego String", "base-string-style");
        this.addStyle(BPMFUEGO_NUMBER_STYLE, "BPM Fuego Number", "base-number-style");
        this.addStyle(BPMFUEGO_TIME_STYLE, "BPM Fuego Time", "base-number-style");
    }

    @Override
    public String mapTokenToStyleName(int token) {
        String result = null;
        switch (token) {
            case 7: {
                result = BPMFUEGO_IDENTIFIER_STYLE;
                break;
            }
            case 8: 
            case 9: {
                result = BPMFUEGO_COMMENT_STYLE;
                break;
            }
            case 10: {
                result = BPMFUEGO_STRING_STYLE;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                result = BPMFUEGO_NUMBER_STYLE;
                break;
            }
            case 14: 
            case 15: {
                result = BPMFUEGO_TIME_STYLE;
                break;
            }
            default: {
                if (token < 19) break;
                result = BPMFUEGO_KEYWORD_STYLE;
            }
        }
        return result;
    }

    @Override
    @NotNull
    public String getContentSample() {
        StringBuilder result = new StringBuilder();
        result.append("/**\n");
        result.append(" * This is written on a\n");
        result.append(" * Multi-line comment\n");
        result.append(" */\n\n");
        result.append("firstName as String\n");
        result.append("lastName as String\n");
        result.append("selectedButton as String\n\n");
        result.append("intValue as Int\n");
        result.append("timeValue as Time\n\n");
        result.append("// Ask the person's name\n");
        result.append("input \"First Name:\" : firstName, \"Last Name:\" : lastName\n");
        result.append("    using title = \"Enter Your Name\", buttons = [\"Done\", \"Cancel\"]\n");
        result.append("    returning selectedButton = selection\n\n");
        result.append("// Check the button pressed\n");
        result.append("if selectedButton = \"Done\" or selectedButton = \"Ok\" then\n");
        result.append("    display \"Hello \" + firstName + \"!\"\n");
        result.append("else\n");
        result.append("    display \"Hello!\"\n");
        result.append("end\n\n");
        result.append("intValue = 406\n");
        result.append("timeValue = '1997/12/12'\n\n");
        return result.toString();
    }

    @Override
    @NotNull
    public String getPresentationName() {
        return "BPM Fuego Skin";
    }

    @Override
    public boolean isMultiLineToken(int token) {
        return token == 9;
    }

    @Override
    @NotNull
    public LanguageSpec createLanguageSpec() {
        return new FuegoLanguageSpec(2);
    }
}

