/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor.fileoverview;

import java.awt.Color;
import javax.swing.text.BadLocationException;
import oracle.bpm.cil.CilException;
import oracle.bpm.fusion.studio.codeeditor.FusionCodeEditor;
import oracle.bpm.fusion.studio.codeeditor.FusionDocument;
import oracle.bpm.fusion.studio.codeeditor.FusionDocumentListener;
import oracle.bpm.fusion.studio.codeeditor.fileoverview.HighlightMark;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import org.jetbrains.annotations.NotNull;

public class FusionFileOverviewPlugin
extends FileOverviewMargin {
    private FusionCodeEditor editor;
    private HighlightStyle errorMarkStyle;
    public static final String MARK_CATEGORY = "!codehighlight";
    private static final long serialVersionUID = 7880543907507469511L;

    public FusionFileOverviewPlugin(@NotNull FusionCodeEditor editor) {
        this.editor = editor;
        FileOverviewMargin.setMarkColor((String)MARK_CATEGORY, (HighlightStyle)this.getErrorMarkStyle());
        this.getDocument().addFusionDocumentListener(new FusionDocumentListener(){

            @Override
            public void compilationStarted() {
                FusionFileOverviewPlugin.this.startAnalysis(FusionFileOverviewPlugin.this.getDocument().getTimestamp(), "Analyzing...");
            }

            @Override
            public void compilationFinished() {
                FusionFileOverviewPlugin.this.markErrors();
                FusionFileOverviewPlugin.this.stopAnalysis(FusionFileOverviewPlugin.this.getDocument().getTimestamp());
            }
        });
    }

    private FusionDocument getDocument() {
        return this.editor.getEditorDocument();
    }

    private void markErrors() {
        this.clearMarks(MARK_CATEGORY);
        for (CilException error : this.getDocument().getErrors()) {
            try {
                HighlightMark highlightMark = new HighlightMark(error.getOffset(), error.getLength(), error.getMessage());
                this.addMark(MARK_CATEGORY, this.getDocument().getLineOfOffset(error.getOffset()), highlightMark);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    private HighlightStyle getErrorMarkStyle() {
        if (this.errorMarkStyle == null) {
            EditorProperties properties = EditorProperties.getProperties();
            HighlightRegistry registry = properties.getHighlightRegistry();
            this.errorMarkStyle = registry.createStyle("errorMarkStyle", "errorMarkStyle", true, 75, Color.BLACK, Color.RED);
        }
        return this.errorMarkStyle;
    }
}

