/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor;

import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LineBreakPoint;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.CodeFixHandler;
import oracle.bpm.editor.EditorContext;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.editor.EditorSupport;
import oracle.bpm.editor.UndoRedoListener;
import oracle.bpm.fusion.studio.codeeditor.FusionDocument;
import oracle.bpm.fusion.studio.codeeditor.codecompletion.CompletionInsightPlugin;
import oracle.bpm.fusion.studio.codeeditor.syntaxhighlight.SyntaxHighlightPlugin;
import oracle.bpm.fusion.studio.codeeditor.underline.UnderlinePlugin;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.plugins.EditorPlugin;
import org.jetbrains.annotations.NotNull;

public class FusionCodeEditor
extends JPanel
implements CodeEditor,
Serializable {
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private EditorContext context;
    private BasicEditorPane editor = new BasicEditorPane();
    private static final long serialVersionUID = 8905207765536994221L;

    public FusionCodeEditor(@NotNull ExpressionContext context, boolean isMultiLine) {
        this.installDocument(this.editor, context);
        this.installPlugins(this.editor);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 0, fill"));
        if (isMultiLine) {
            JScrollPane scrollPane = new JScrollPane((Component)this.editor);
            scrollPane.setVerticalScrollBarPolicy(22);
            this.add((Component)scrollPane, "grow");
        } else {
            this.editor.addActionHookInvoker(new ActionHookInvoker(){

                public boolean invokeAction(String actionKey) {
                    return actionKey.equals("insert-break");
                }
            });
            JScrollPane scrollPane = new JScrollPane((Component)this.editor);
            scrollPane.setVerticalScrollBarPolicy(21);
            scrollPane.setHorizontalScrollBarPolicy(31);
            this.add((Component)scrollPane, "growx, height 20!");
        }
        this.initListeners();
    }

    public BasicEditorPane getTextEditor() {
        return this.editor;
    }

    @Override
    public boolean isEnabled() {
        return this.editor.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.editor.setEnabled(enabled);
    }

    public FusionDocument getEditorDocument() {
        Document doc = this.editor.getDocument();
        return doc instanceof FusionDocument ? (FusionDocument)((Object)doc) : null;
    }

    public LanguageSpec getLanguage() {
        return this.getEditorDocument().getLanguage();
    }

    public void touch() {
        this.getEditorDocument().touch();
    }

    public void setCaretPosition(int offset) {
        this.editor.setCaretPosition(offset);
    }

    public int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    public void setEditable(boolean editable) {
        this.editor.setEditable(editable);
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.editor.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.editor.getSelectionStart();
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    public String getText() {
        return this.editor.getText();
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.editor.getText(offset, length);
    }

    public void select(int start, int end) {
        this.editor.select(start, end);
    }

    public UiComponent getView() {
        return UiComponent.get((Object)this);
    }

    public UiComponent getDroppableComponent() {
        return UiComponent.get((Object)this.editor);
    }

    public void updateCompilationStatus() {
    }

    public Action getActionByName(String name) {
        return null;
    }

    public void setAddToolBar(boolean addToolBar) {
    }

    public boolean isAddToolBar() {
        return false;
    }

    public void setCanBrowseDeclarations(boolean canBrowse) {
    }

    public void setCloseAction(BaseAction action) {
    }

    public void setCode(MethodTypeDescription code) {
    }

    public MethodTypeDescription getCode() {
        return null;
    }

    public void setCompilerDirectives(int directives) {
    }

    public void setExpression(boolean expression) {
    }

    public boolean isExpression() {
        return false;
    }

    public void setExpressionRequired(boolean required) {
    }

    public boolean isExpressionRequired() {
        return false;
    }

    public void setFixHandler(CodeFixHandler fixHandler) {
    }

    public List<LineBreakPoint> getLineBreakPoints() {
        return null;
    }

    public CodeDebugger.CILSource getSource() {
        return null;
    }

    public void setSupport(EditorSupport support) {
    }

    public EditorSupport getSupport() {
        return null;
    }

    public ToolBar getToolBar() {
        return null;
    }

    public void setUndoRedoListener(UndoRedoListener listener) {
    }

    public void setValidate(boolean validate) {
    }

    public boolean isValidate() {
        return false;
    }

    public void addBreakPointMark(BreakPoint breakPoint) {
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void addDependableAction(Action action) {
    }

    public void addEdit(UndoableEdit undoableEdit) {
    }

    public void addError(CilException exception) {
    }

    public void addKeyListener(KeyListener listener) {
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    public void addWarning(CilException warning) {
    }

    public void checkChangeLanguage() {
    }

    public void clearUndoEvents() {
    }

    public boolean containsDependableAction(Action action) {
        return false;
    }

    public void extractBreakPoints(List breakPointList) {
    }

    public void focusLost() {
    }

    public void goToStart() {
    }

    public void marksChanged() {
    }

    public void removeDependableAction(Action action) {
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    public void runActionByName(String name) {
    }

    public void selectLine(int line) {
    }

    public void setSelectionProvider(SelectionProvider selectionProvider) {
    }

    private void installDocument(@NotNull BasicEditorPane editor, @NotNull ExpressionContext context) {
        FusionDocument fusionDocument = new FusionDocument(context);
        editor.setDocument((Document)((Object)fusionDocument));
        this.getContext().setDocument((EditorDocument)fusionDocument, true);
    }

    private void installPlugins(@NotNull BasicEditorPane editor) {
        editor.installPlugin((EditorPlugin)new SyntaxHighlightPlugin());
        editor.installPlugin((EditorPlugin)new CompletionInsightPlugin());
        UnderlinePlugin underlinePlugin = new UnderlinePlugin();
        editor.installPlugin((EditorPlugin)underlinePlugin);
        editor.addToolTipProvider((ToolTipProvider)underlinePlugin);
        editor.putBooleanProperty("insight-manual-complete-single", true);
    }

    private EditorContext getContext() {
        if (this.context == null) {
            this.context = new EditorContext();
        }
        return this.context;
    }

    private void initListeners() {
        this.getEditorDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FusionCodeEditor.this.fireEditorChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FusionCodeEditor.this.fireEditorChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FusionCodeEditor.this.fireEditorChanged();
            }
        });
    }

    private void fireEditorChanged() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent((Object)this));
        }
    }
}

