/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.casemgmt;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.fusion.studio.casemgmt.PromotePanelBuilder;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import org.jetbrains.annotations.Nullable;

public abstract class PromoteToCaseActivityDialog<E extends ProjectObject>
extends JEWTDialog {
    private PromotePanelBuilder<E> promotePanelBuilder;

    private PromoteToCaseActivityDialog(Frame parent, E objectToPromote) {
        super(parent, CaseUiMsg.CREATE_CASE_ACTIVITY.getString(), 7);
        this.promotePanelBuilder = this.createPromoteToPanelBuilder(objectToPromote);
        this.init();
    }

    @Nullable
    public static CaseActivityInfo show(Process process) {
        ProcessDialog dialog = new ProcessDialog((Frame)Ide.getMainWindow(), process);
        boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
        return ok ? super.createCaseActivityInfo() : null;
    }

    @Nullable
    public static CaseActivityInfo show(HumanTask humantask) {
        HumanTaskDialog dialog = new HumanTaskDialog((Frame)Ide.getMainWindow(), humantask);
        boolean ok = WizardLauncher.runDialog((JDialog)((Object)dialog));
        return ok ? super.createCaseActivityInfo() : null;
    }

    abstract PromotePanelBuilder<E> createPromoteToPanelBuilder(E var1);

    private CaseActivityInfo createCaseActivityInfo() {
        return this.promotePanelBuilder.createCaseActivityInfo();
    }

    private void init() {
        UiComponent uiComponent = this.promotePanelBuilder.buildEditor(UiContainer.NULL);
        this.setContent(uiComponent.asSwing());
        HelpSystem.getHelpSystem().registerTopic(uiComponent.asSwing(), "f1_bpm_casemgcreatecactd_html");
        this.addVetoableChangeListener(this.createValidationListener());
    }

    private VetoableChangeListener createValidationListener() {
        return new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    ProjectCaseActivity otherCaseActivity;
                    String name = PromoteToCaseActivityDialog.this.promotePanelBuilder.getName();
                    if (Str.isEmpty(name)) {
                        MessageDialog.showError((Msg)CaseUiMsg.INVALID_FILE_NAME, (Msg)CaseUiMsg.INVALID_FILE_NAME_DESCRIPTION);
                        throw new PropertyVetoException("", evt);
                    }
                    Object objectToPromote = PromoteToCaseActivityDialog.this.promotePanelBuilder.getObjectToPromote();
                    Project project = objectToPromote.getProject();
                    ProjectCase projectCase = project.getCase();
                    if (projectCase != null && (otherCaseActivity = projectCase.findCaseActivity(name)) != null) {
                        MessageDialog.showError((Msg)CaseUiMsg.INVALID_FILE_NAME, (Msg)CaseUiMsg.FILE_NAME_USED);
                        throw new PropertyVetoException("", evt);
                    }
                    if (Str.isEmpty(PromoteToCaseActivityDialog.this.promotePanelBuilder.getDisplayName())) {
                        MessageDialog.showError((Msg)CaseUiMsg.INVALID_DISPLAY_NAME, (Msg)CaseUiMsg.INVALID_DISPLAY_NAME_DESCRIPTION);
                        throw new PropertyVetoException("", evt);
                    }
                }
            }
        };
    }

    /* synthetic */ PromoteToCaseActivityDialog(Frame x0, ProjectObject x1, 1 x2) {
        this(x0, x1);
    }

    private static class ProcessDialog
    extends PromoteToCaseActivityDialog<Process> {
        private ProcessDialog(Frame parent, Process process) {
            super(parent, (ProjectObject)process, null);
        }

        @Override
        PromotePanelBuilder<Process> createPromoteToPanelBuilder(Process process) {
            return PromotePanelBuilder.create(process);
        }
    }

    private static class HumanTaskDialog
    extends PromoteToCaseActivityDialog<HumanTask> {
        private HumanTaskDialog(Frame parent, HumanTask humantask) {
            super(parent, (ProjectObject)humantask, null);
        }

        @Override
        PromotePanelBuilder<HumanTask> createPromoteToPanelBuilder(HumanTask humanTask) {
            return PromotePanelBuilder.create(humanTask);
        }
    }
}

