/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.casemgmt;

import java.net.URL;
import java.util.Collection;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.studio.casemgmt.PromotePanelBuilder;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.conversation.Conversation;
import oracle.bpm.project.model.processes.conversation.ConversationType;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.net.URLFileSystem;

class PromoteProcessPanelBuilder
extends PromotePanelBuilder<Process> {
    private TextField displayNameTextField;
    private IdentifierTextField nameTextField;
    private ComboBox<CatchEvent> operationCombo;
    private CheckBox synchronousCheckBox;
    private static final boolean SYNCHRONOUS_VALUE = true;

    public PromoteProcessPanelBuilder(Process process) {
        super(process);
    }

    @Override
    public UiComponent buildEditor(UiContainer parent) {
        Panel panel = new Panel(parent);
        String name = this.getDefaultName();
        this.nameTextField = new IdentifierTextField((UiContainer)panel, name, 30, true);
        this.nameTextField.setTextLimit(80);
        this.displayNameTextField = new TextField((UiContainer)panel, name, 30);
        this.nameTextField.addDocumentListener((DocumentListener)new DocumentListener.Default(){

            public void anyUpdate(DocumentEvent e) {
                PromoteProcessPanelBuilder.this.displayNameTextField.setText(PromoteProcessPanelBuilder.this.nameTextField.getText());
            }
        });
        Process process = (Process)this.getObjectToPromote();
        Collection operations = CaseActivityUtils.getOperations((Process)process);
        this.operationCombo = UiFactory.createComboBox((UiContainer)panel, (Collection)operations);
        this.operationCombo.setLabelProvider((LabelProvider)OperationLabelProvider.create());
        this.synchronousCheckBox = CheckBox.create((UiContainer)panel, (Msg)CaseUiMsg.SYNCHRONOUS, (boolean)true);
        this.synchronousCheckBox.setEnabled(false);
        if (!operations.isEmpty()) {
            CatchEvent catchEvent = (CatchEvent)operations.iterator().next();
            this.operationCombo.setSelectedItem((Object)catchEvent);
            this.synchronousCheckBox.setSelected(CaseActivityUtils.isSynchronous((CatchEvent)catchEvent));
        }
        if (operations.size() > 1) {
            this.operationCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    CatchEvent item = (CatchEvent)PromoteProcessPanelBuilder.this.operationCombo.getSelectedItem();
                    boolean isSync = CaseActivityUtils.isSynchronous((CatchEvent)item);
                    PromoteProcessPanelBuilder.this.synchronousCheckBox.setSelected(isSync);
                }
            });
        }
        panel.setLayout((Layout)new MigLayout("fillx, gapy 6, gapx 8, ins 0"));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CoreMsg.NAME));
        panel.add((UiComponent)this.nameTextField, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CaseUiMsg.DISPLAY_NAME));
        panel.add((UiComponent)this.displayNameTextField, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CaseUiMsg.OPERATION_NAME));
        panel.add(this.operationCombo, (Object)"growx, pushx, wrap");
        panel.add((UiComponent)this.synchronousCheckBox, (Object)"skip");
        return panel;
    }

    @Override
    public String getName() {
        return this.nameTextField.getText();
    }

    @Override
    public String getDisplayName() {
        return this.displayNameTextField.getText();
    }

    @Override
    public CaseActivityInfo createCaseActivityInfo() {
        CaseActivity result = CaseActivityFactory.createCaseActivity();
        String name = this.getName();
        result.setId("${domain_id}_${process_id}_${process_revision}_" + name);
        result.setName(name);
        String targetNamespace = this.getCase().getTargetNamespace();
        result.setTargetNamespace(targetNamespace + "/" + name);
        result.setActivity((Activity)this.createBpmnActivity());
        return CaseActivityInfo.create((CaseActivity)result, (String)this.getDisplayName());
    }

    private String getProcessName() {
        URL url = this.getObjectToPromoteUrl();
        return url != null ? URLFileSystem.getName((URL)url) : ((Process)this.getObjectToPromote()).getName();
    }

    private Activity.Bpmn createBpmnActivity() {
        Activity.Bpmn result = CaseActivityFactory.createBpmnActivity();
        result.setInputParameters(this.createBpmnInputParameters());
        result.setOutputParameters(this.createBpmnOutputParameters());
        result.setComponentInfo(this.createBpmnComponentInfo());
        return result;
    }

    private ComponentInfo createBpmnComponentInfo() {
        Process process = (Process)this.getObjectToPromote();
        ComponentInfo result = CaseActivityFactory.createComponentInfo();
        result.setReference(this.getProcessName() + ".service.reference");
        result.setNamespace(process.getNamespace());
        CatchEvent start = (CatchEvent)this.operationCombo.getSelectedItem();
        if (start != null) {
            result.setOperation(CaseActivityUtils.getOperationName((CatchEvent)start));
        }
        result.setSynchronous(this.synchronousCheckBox.isSelected());
        return result;
    }

    private InputParameters createBpmnInputParameters() {
        CatchEvent catchEvent = (CatchEvent)this.operationCombo.getSelectedItem();
        InputParameters result = catchEvent != null ? CaseActivityUtils.createInputParameters((CatchEvent)catchEvent, (Case)this.getCase()) : CaseActivityFactory.createInputParameters();
        return result;
    }

    private OutputParameters createBpmnOutputParameters() {
        CatchEvent catchEvent = (CatchEvent)this.operationCombo.getSelectedItem();
        return catchEvent != null ? CaseActivityUtils.createOutputParameters((Conversational)catchEvent, (Case)this.getCase()) : CaseActivityFactory.createOutputParameters();
    }

    private static class OperationLabelProvider
    extends LabelProvider.Default<CatchEvent> {
        private OperationLabelProvider() {
        }

        public static OperationLabelProvider create() {
            return new OperationLabelProvider();
        }

        public Image getIcon(CatchEvent element) {
            Conversation conversation = element.getConversation();
            ConversationType type = conversation != null ? conversation.getConversationType() : null;
            Msg msg = type != null ? type.getMsg() : DesignerMsg.NOT_IMPLEMENTED;
            return Image.create((Msg)msg);
        }

        public String getText(CatchEvent element) {
            return CaseActivityUtils.getOperationName((CatchEvent)element);
        }
    }
}

