/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.casemgmt;

import java.net.URL;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.fusion.studio.casemgmt.PromoteHumanTaskPanelBuilder;
import oracle.bpm.fusion.studio.casemgmt.PromoteProcessPanelBuilder;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.ProjectCase;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.ide.net.URLFileSystem;

abstract class PromotePanelBuilder<E extends ProjectObject> {
    private E objectToPromote;
    protected static final String SERVICE_REFERENCE = ".service.reference";
    protected static final String BASE_ID = "${domain_id}_${process_id}_${process_revision}_";

    protected PromotePanelBuilder(E objectToPromote) {
        this.objectToPromote = objectToPromote;
    }

    public static PromoteProcessPanelBuilder create(Process process) {
        return new PromoteProcessPanelBuilder(process);
    }

    public static PromoteHumanTaskPanelBuilder create(HumanTask humanTask) {
        return new PromoteHumanTaskPanelBuilder(humanTask);
    }

    protected abstract UiComponent buildEditor(UiContainer var1);

    protected abstract String getName();

    protected abstract String getDisplayName();

    protected abstract CaseActivityInfo createCaseActivityInfo();

    protected static <T> T adaptTo(Object object, Class<T> cl) {
        return Platform.getAdapterService().adaptTo(object, cl);
    }

    protected E getObjectToPromote() {
        return this.objectToPromote;
    }

    protected URL getObjectToPromoteUrl() {
        E object = this.getObjectToPromote();
        return PromotePanelBuilder.adaptTo(object, URL.class);
    }

    protected String getDefaultName() {
        String result;
        URL url = this.getObjectToPromoteUrl();
        if (url != null) {
            URL parent = URLFileSystem.getParent((URL)url);
            String name = URLFileSystem.getName((URL)url);
            result = this.getAvailableName(name);
        } else {
            result = this.getObjectToPromote().getName();
        }
        return result;
    }

    protected Case getCase() {
        return this.getProjectCase().getCase();
    }

    protected ProjectCase getProjectCase() {
        Project project = this.getObjectToPromote().getProject();
        return project.getCase();
    }

    private String getAvailableName(String baseName) {
        ProjectCase projectCase = this.getProjectCase();
        int i = 0;
        String name = baseName;
        while (projectCase.findCaseActivity(name) != null) {
            name = baseName + i++;
        }
        return name;
    }
}

