/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.casemgmt;

import java.net.URL;
import oracle.bpm.casemgmt.model.ca.Activity;
import oracle.bpm.casemgmt.model.ca.CaseActivity;
import oracle.bpm.casemgmt.model.ca.CaseActivityFactory;
import oracle.bpm.casemgmt.model.ca.ComponentInfo;
import oracle.bpm.casemgmt.model.ca.InputParameters;
import oracle.bpm.casemgmt.model.ca.OutputParameters;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.fusion.studio.casemgmt.PromotePanelBuilder;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.model.casemgmt.CaseActivityUtils;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;
import oracle.ide.net.URLFileSystem;

class PromoteHumanTaskPanelBuilder
extends PromotePanelBuilder<HumanTask> {
    private TextField displayNameTextField;
    private IdentifierTextField nameTextField;
    private static final String OPERATION_NAME = "initiateTask";
    private static final String NAMESPACE = "http://xmlns.oracle.com/bpel/workflow/taskService";

    public PromoteHumanTaskPanelBuilder(HumanTask process) {
        super(process);
    }

    @Override
    public UiComponent buildEditor(UiContainer parent) {
        Panel panel = new Panel(parent);
        String defaultName = this.getDefaultName();
        this.nameTextField = new IdentifierTextField((UiContainer)panel, defaultName, 30, true);
        this.nameTextField.setTextLimit(80);
        this.displayNameTextField = new TextField((UiContainer)panel, defaultName, 30);
        this.nameTextField.addDocumentListener((DocumentListener)new DocumentListener.Default(){

            public void anyUpdate(DocumentEvent e) {
                PromoteHumanTaskPanelBuilder.this.displayNameTextField.setText(PromoteHumanTaskPanelBuilder.this.nameTextField.getText());
            }
        });
        panel.setLayout((Layout)new MigLayout("fillx, gapx 8, gapy 6, ins 0"));
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CoreMsg.NAME));
        panel.add((UiComponent)this.nameTextField, (Object)"wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)CaseUiMsg.DISPLAY_NAME));
        panel.add((UiComponent)this.displayNameTextField, (Object)"wrap");
        return panel;
    }

    @Override
    public String getName() {
        return this.nameTextField.getText();
    }

    @Override
    public String getDisplayName() {
        return this.displayNameTextField.getText();
    }

    @Override
    public CaseActivityInfo createCaseActivityInfo() {
        CaseActivity result = CaseActivityFactory.createCaseActivity();
        String name = this.getName();
        result.setId("${domain_id}_${process_id}_${process_revision}_" + name);
        result.setName(name);
        String targetNamespace = this.getCase().getTargetNamespace();
        result.setTargetNamespace(targetNamespace + "/" + name);
        result.setActivity((Activity)this.createHumantaskActivity());
        return CaseActivityInfo.create((CaseActivity)result, (String)this.getDisplayName());
    }

    private String getHumanTaskName() {
        URL url = this.getObjectToPromoteUrl();
        return url != null ? URLFileSystem.getName((URL)url) : ((HumanTask)this.getObjectToPromote()).getName();
    }

    private Activity.Humantask createHumantaskActivity() {
        Activity.Humantask result = CaseActivityFactory.createHumantaskActivity();
        result.setInputParameters(this.createHumanTaskInputParameters());
        result.setOutputParameters(this.createHumanTaskOutputParameters());
        result.setComponentInfo(this.createHumanTaskComponentInfo());
        return result;
    }

    private ComponentInfo createHumanTaskComponentInfo() {
        ComponentInfo result = CaseActivityFactory.createComponentInfo();
        result.setReference(this.getHumanTaskName() + ".service.reference");
        result.setNamespace(NAMESPACE);
        result.setOperation(OPERATION_NAME);
        return result;
    }

    private InputParameters createHumanTaskInputParameters() {
        HumanTask task = (HumanTask)this.getObjectToPromote();
        return CaseActivityUtils.createInputParameters((HumanTask)task, (Case)this.getCase());
    }

    private OutputParameters createHumanTaskOutputParameters() {
        HumanTask task = (HumanTask)this.getObjectToPromote();
        return CaseActivityUtils.createOutputParameters((HumanTask)task, (Case)this.getCase());
    }
}

