/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.casemgmt;

import java.awt.Component;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.bpm.casemgmt.model.cm.Case;
import oracle.bpm.casemgmt.ui.CaseUtils;
import oracle.bpm.casemgmt.ui.ca.CaseActivityNode;
import oracle.bpm.casemgmt.ui.common.CaseActivityInfo;
import oracle.bpm.casemgmt.ui.msg.CaseUiMsg;
import oracle.bpm.fusion.core.ProcessNode;
import oracle.bpm.fusion.studio.casemgmt.PromoteToCaseActivityDialog;
import oracle.bpm.project.catalog.common.Utils;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.casemgmt.CaseManagementUtils;
import oracle.bpm.project.model.casemgmt.ProjectCaseActivity;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;

public class CaseContextMenuListener
implements ContextMenuListener,
Controller {
    private static final int PROMOTE_COMMAND_ID = Ide.findOrCreateCmdID((String)"oracle.bpm.studio.casemgmt.promote");
    private static Logger LOGGER = Logger.getLogger(CaseContextMenuListener.class.getName());

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        oracle.bpm.project.model.Project bpmProject;
        Context context = contextMenu.getContext();
        Project project = context.getProject();
        if (project != null && (bpmProject = CaseUtils.getBpmProject((Project)project)) != null && CaseUtils.getCase((oracle.bpm.project.model.Project)bpmProject) != null && (this.getSelectedProcess(context) != null || this.getSelectedHumantask(context) != null)) {
            IdeAction promoteAction = this.createPromoteAction();
            contextMenu.addSeparator();
            JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)promoteAction);
            contextMenu.add((Component)menuItem);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int id = ideAction.getCommandId();
        if (PROMOTE_COMMAND_ID == id) {
            CaseActivityInfo caseActivityInfo = null;
            try {
                ProjectCaseActivity projectCaseActivity;
                URL url;
                Project project = context.getProject();
                oracle.bpm.project.model.Project bpmProject = CaseUtils.getBpmProject((Project)project);
                Case casemgmt = CaseUtils.getCase((oracle.bpm.project.model.Project)bpmProject);
                Process process = this.getSelectedProcess(context);
                if (process != null) {
                    caseActivityInfo = PromoteToCaseActivityDialog.show(process);
                } else {
                    HumanTask humantask = this.getSelectedHumantask(context);
                    if (humantask != null) {
                        caseActivityInfo = PromoteToCaseActivityDialog.show(humantask);
                    }
                }
                if (caseActivityInfo != null && (url = (URL)CaseUtils.adaptTo((Object)(projectCaseActivity = CaseUtils.createProjectCaseActivity((Project)context.getProject(), (CaseActivityInfo)caseActivityInfo)), URL.class)) != null) {
                    CaseActivityNode caseActivityNode = (CaseActivityNode)NodeFactory.findOrCreate(CaseActivityNode.class, (URL)url);
                    EditorUtil.openExplicitDefaultEditorInFrame((Node)caseActivityNode);
                }
            }
            catch (Exception e) {
                LOGGER.logp(Level.SEVERE, "CaseActivityWizard", "invoke", "Failed to create CaseActivity", e);
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (PROMOTE_COMMAND_ID == ideAction.getCommandId()) {
            boolean enable = true;
            Process process = this.getSelectedProcess(context);
            if (process != null) {
                enable = Utils.hasServiceInterfaceDefined((Process)process);
            }
            ideAction.setEnabled(enable);
        }
        return true;
    }

    private Process getSelectedProcess(Context context) {
        ProcessNode node;
        ProjectObject object;
        Process result = null;
        if (context != null && context.getNode() instanceof ProcessNode && (object = (node = (ProcessNode)context.getNode()).getObject()) instanceof Process) {
            result = (Process)object;
        }
        return result;
    }

    private HumanTask getSelectedHumantask(Context context) {
        oracle.bpm.project.model.Project bpmProject;
        URL url;
        String suffix;
        HumanTask result = null;
        if (context != null && context.getNode() != null && context.getNode().getURL() != null && ".task".equals(suffix = URLFileSystem.getSuffix((URL)(url = context.getNode().getURL()))) && (bpmProject = CaseUtils.getBpmProject((Project)context.getProject())) != null) {
            String humanTaskName = URLFileSystem.getName((URL)url);
            result = CaseManagementUtils.getHumanTask((oracle.bpm.project.model.Project)bpmProject, (String)humanTaskName);
        }
        return result;
    }

    private IdeAction createPromoteAction() {
        return this.createAction(PROMOTE_COMMAND_ID, CaseUiMsg.PROMOTE_AS_CASE_ACTIVITY, 80, CaseActivityNode.ICON, this);
    }

    private IdeAction createAction(int cmd, Msg msg, int mnemonicKey, Icon icon, Controller controller) {
        IdeAction action = IdeAction.get((int)cmd, (String)this.getClass().toString(), (String)msg.getString());
        action.addController(controller);
        action.putValue("MnemonicKey", (Object)mnemonicKey);
        action.putValue("BPM_ACTION", (Object)true);
        if (icon != null) {
            action.putValue("SmallIcon", (Object)icon);
        }
        return action;
    }
}

