/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.actions;

import oracle.bpm.fusion.core.model.StudioNode;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public class DefaultStudioActionController
implements Controller {
    private BaseAction designerAction;

    public DefaultStudioActionController() {
    }

    public DefaultStudioActionController(BaseAction designerAction) {
        this.designerAction = designerAction;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (this.designerAction != null) {
            this.configureSelection(context);
            this.designerAction.run();
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (this.designerAction == null) {
            this.initDesignerAction(ideAction);
        }
        this.configureSelection(context);
        Image icon = Image.create((Msg)this.designerAction.getMsg());
        if (icon != null) {
            ideAction.putValue("SmallIcon", (Object)icon.asSwingIcon());
        }
        ideAction.setName(this.designerAction.getMsg().getString());
        ideAction.setEnabled(this.designerAction.isEnabled());
        return false;
    }

    private void configureSelection(Context context) {
        if (context.getNode() instanceof StudioNode) {
            StudioNode projectObjectNode = (StudioNode)context.getNode();
            Selection selection = DefaultSelection.createSingle((Object)projectObjectNode);
            this.designerAction.setSelection(selection);
        } else {
            this.designerAction.setSelection(DefaultSelection.EMPTY);
        }
    }

    private void initDesignerAction(IdeAction ideAction) {
        try {
            String actionClass = (String)ideAction.getValue("ActionClass");
            Class<?> forName = Class.forName(actionClass);
            this.designerAction = (BaseAction)forName.newInstance();
        }
        catch (ClassNotFoundException e) {
            Log.logTrace(e);
        }
        catch (InstantiationException e) {
            Log.logTrace(e);
        }
        catch (IllegalAccessException e) {
            Log.logTrace(e);
        }
    }
}

