/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.fusion.studio.TranslationServiceImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class TranslationServiceFactory {
    private Map<File, TranslationServiceImpl> translationServiceCache = new HashMap<File, TranslationServiceImpl>();
    private static TranslationServiceFactory instance;

    private TranslationServiceFactory() {
    }

    public static synchronized TranslationServiceFactory getInstance() {
        if (instance == null) {
            instance = new TranslationServiceFactory();
        }
        return instance;
    }

    public TranslationServiceImpl createTranslationService(@NotNull UiContainer parent, @NotNull Project project, String resourceBundleName) {
        TranslationServiceImpl translationService;
        File projectRootFolder = project.getLoader().getProjectFileSystem().getLocalFileSystem().getRootFolder();
        File resourceBundleFile = new File(projectRootFolder, resourceBundleName);
        if (this.translationServiceCache.get(resourceBundleFile) == null && (translationService = new TranslationServiceImpl()).init(parent, project, resourceBundleName)) {
            this.translationServiceCache.put(resourceBundleFile, translationService);
        }
        return this.translationServiceCache.get(resourceBundleFile);
    }
}

