/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.core.ProcessNode;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.core.recognizer.FusionStudioRecognizer;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.fusion.studio.FusionWorkbench;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.StudioPreferences;
import oracle.bpm.fusion.studio.StudioPrintFactory;
import oracle.bpm.fusion.studio.actions.StudioController;
import oracle.bpm.fusion.studio.addin.CollaborationEditorAddin;
import oracle.bpm.fusion.studio.addin.FusionEditorAddin;
import oracle.bpm.fusion.studio.addin.ProcessEditorAddin;
import oracle.bpm.fusion.studio.help.JdevHelpService;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.fusion.studio.navigator.ProjectNavigatorManager;
import oracle.bpm.fusion.studio.structure.BpmStructureExplorer;
import oracle.bpm.fusion.studio.thumbnail.ProcessThumbnailViewFactory;
import oracle.bpm.fusion.studio.views.StudioDockableFactory;
import oracle.bpm.fusion.ui.editor.FusionEditor;
import oracle.bpm.lang.Id;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.help.HelpService;
import oracle.diagram.thumbnail.ThumbnailDockable;
import oracle.diagram.thumbnail.ThumbnailViewFactory;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.layout.Layout;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.Element;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.PrintManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public class StudioExtensionAddin
implements Addin {
    public static boolean isBusinessAnalyst() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        return Product.isBPMStudio() || extensionRegistry.getRoleManager().getActiveRole().getId().equals("oracle.bpm.role");
    }

    public void initialize() {
        System.setProperty("BPM_INSTALLED", "true");
        if (StudioExtensionAddin.isBusinessAnalyst()) {
            this.init();
        }
    }

    protected void init() {
        JdevRepositoryService.getInstance();
        Ui.enableSVG();
        if (AbstractStudioWorkbench.getInstance() == null) {
            AbstractStudioWorkbench.setInstance((StudioWorkbench)new FusionWorkbench());
        }
        Ide.getVersionInfo().addComponent(FusionStudioMsg.BPMN_EDITOR.toString(), Id.getJDevVersion());
        this.registerRecognizers();
        EditorManager.getEditorManager().register((EditorAddin)new FusionEditorAddin(), new Class[]{ProjectObjectNode.class});
        EditorManager.getEditorManager().register((EditorAddin)new ProcessEditorAddin(), new Class[]{ProcessNode.class});
        EditorManager.getEditorManager().register((EditorAddin)new CollaborationEditorAddin(), new Class[]{ProcessNode.class});
        StudioController.createActions();
        DockStation.getDockStation().registerDockableFactory("BpmStudioView", (DockableFactory)StudioDockableFactory.getInstance());
        this.registerLayoutListener();
        this.initializeProjectNavigator();
        this.registerBpmStructurePane();
        this.initHelpService();
        this.registerPrintFactory();
        this.registerThumbnailFactory();
        this.registerGallery();
    }

    private void registerLayoutListener() {
        EditorManager.getEditorManager().registerPreferredLayoutListener(ProcessNode.class, FusionEditor.class, "FusionLayout", (PreferredLayoutListener)new FusionLayoutListener());
    }

    private void registerGallery() {
        if (Product.isBPMStudio()) {
            ElementInfo info = new ElementInfo("General", "Projects", "oracle.bpm.fusion.studio.wizard.NewBpmProjectWizard", new String[0], DesignerMsg.NEW_PROJECT.toString(), DesignerMsg.NEW_PROJECT_DESC.toString(), null, true);
            info.setTechnologyKeys(new String[]{"BPM"});
            ElementInfo info2 = new ElementInfo("General", "BPM Tier", "oracle.bpm.fusion.studio.wizard.NewBpmProjectWizard", new String[0], DesignerMsg.NEW_PROJECT.toString(), DesignerMsg.NEW_PROJECT_DESC.toString(), null, true);
            info2.setTechnologyKeys(new String[]{"BPM"});
            GalleryManager.getGalleryManager().registerGalleryElement(info);
            GalleryManager.getGalleryManager().registerGalleryElement(info2);
        }
    }

    private void registerRecognizers() {
        FusionStudioRecognizer recognizer = FusionStudioRecognizer.getInstance();
        Recognizer.registerRecognizer((String[])recognizer.getRecognizedExtensions(), (Recognizer)recognizer);
        Recognizer.registerLowPriorityRecognizer((Recognizer)recognizer);
    }

    private void registerPrintFactory() {
        PrintManager manager = PrintManager.getPrintManager();
        manager.registerDocumentPrintFactory(FusionEditor.class, StudioPrintFactory.class);
    }

    private void registerThumbnailFactory() {
        ProcessThumbnailViewFactory thumbnailViewFactory = new ProcessThumbnailViewFactory();
        ThumbnailDockable.registerThumbnailViewFactory(FusionEditor.class, (ThumbnailViewFactory)thumbnailViewFactory);
    }

    private void initializeProjectNavigator() {
        NavigatorManager navigator;
        StudioPreferences studioPreferences = StudioPreferences.getPreferences();
        List<String> workspaces = studioPreferences.getWorkspaces();
        for (String workspaceUrl : workspaces) {
            Workspace workspace = new Workspace();
            try {
                URL url = new URL(workspaceUrl);
                workspace.setURL(url);
                if (!URLFileSystem.exists((URL)url)) continue;
                Ide.getWorkspaces().add((Element)workspace);
            }
            catch (MalformedURLException ignored) {}
        }
        ProjectNavigatorManager.getInstance().initialize();
        if (StudioExtensionAddin.isBusinessAnalyst() && (navigator = NavigatorManager.getApplicationNavigatorManager()) != null) {
            DefaultNavigatorWindow navigatorWindow = (DefaultNavigatorWindow)navigator.getNavigatorWindow();
            navigatorWindow.setDefaultVisibility(1);
        }
    }

    private void registerBpmStructurePane() {
        ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
        explorerManager.register(ProjectObjectNode.class, BpmStructureExplorer.class, null);
    }

    private void initHelpService() {
        Ui.setHelpService((HelpService)new JdevHelpService());
    }

    private class FusionLayoutListener
    implements PreferredLayoutListener {
        private FusionLayoutListener() {
        }

        public void onInitializeLayout(PreferredLayoutEvent preferredLayoutEvent) {
            Layout layout = preferredLayoutEvent.getLayout();
            layout.setProperty("Layout.ShowPalette2", String.valueOf(Boolean.FALSE.toString()));
        }

        public void onPreferredLayoutActivate(PreferredLayoutEvent preferredLayoutEvent) {
        }
    }
}

